<?php $__env->startSection('page_title',__('Product Stock Create')); ?>

<?php $__env->startSection('content'); ?>
	<div class="main-content">
		<section class="section">
			<div class="section-header">
				<h1><?php echo app('translator')->get('Product Stock Create'); ?></h1>
				<div class="section-header-breadcrumb">
					<div class="breadcrumb-item active">
						<a href="<?php echo e(route('user.dashboard')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
					</div>
					<div class="breadcrumb-item"><?php echo app('translator')->get('Product Stock Create'); ?></div>
				</div>
			</div>
			<div class="row mb-3">
				<div class="container-fluid" id="container-wrapper">
					<div class="row justify-content-md-center">
						<div class="col-md-12">
							<div class="card mb-4 card-primary shadow">
								<div
									class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
									<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Product Stock Create'); ?></h6>
								</div>
								<div class="card-body">
									<form action="<?php echo e(route('stock.create')); ?>" method="post">
										<?php echo csrf_field(); ?>
										<div class="row">
											<div class="col-md-4">
												<div class="form-group">
													<label for="Product"><?php echo app('translator')->get('Product'); ?> <sup
															class="text-danger">*</sup></label>
													<select name="product" id="selectProduct"
															class="form-control select2 form-control-sm productSelect <?php $__errorArgs = ['product'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
															required>
														<option disabled selected
																value=""><?php echo app('translator')->get('Select Product'); ?></option>
														<?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
															<option
																value="<?php echo e($product->id); ?>" <?php echo e(old('product') == $product->id ? 'selected':''); ?>><?php echo e($product->name); ?></option>
														<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
														<?php endif; ?>
													</select>
													<div class="invalid-feedback">
														<?php $__errorArgs = ['product'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
													</div>
												</div>
											</div>
										</div>
										<div class="row addedField mt-3">
										</div>
										<button type="submit"
												class="btn btn-primary btn-lg"><?php echo app('translator')->get('Create Stock'); ?></button>
									</form>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

		</section>
	</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('extra_styles'); ?>
	<link rel="stylesheet" href="<?php echo e(asset('assets/store/css/select2.min.css')); ?>">
<?php $__env->stopPush(); ?>
<?php $__env->startSection('scripts'); ?>
	<script src="<?php echo e(asset('assets/store/js/select2.min.js')); ?>"></script>
	<script>
		'use strict';
		var productId;

		$(document).on('change', '.productSelect', function () {
			productId = $(this).val();
			attrCollect(productId);
		});

		$(document).on('click', '.delete_desc', function () {
			$(this).closest('.input-group').parent().remove();
		});

		function attrCollect(productId) {
			$('.addedField').html('');
			$.ajax({
				url: "<?php echo e(route('stock.attr.fetch')); ?>",
				method: "get",
				data: {
					productId: productId,
				},
				success: function (res) {
					if (res.status == 'success') {
						attrAppend(res.data);
					}
				}
			});
		}

		function attrAppend(data) {
			$('.addedField').append(data)
		}

		$(document).ready(function () {
			$('select').select2({
				selectOnClose: true
			});
		});


		$(document).on('click', '.removeContentDiv', function () {
			var sss = $(this).closest('.column-form').remove();
		});


		$(document).on('click', '.copyFormData', function () {
			var sss = $(this).closest('.column-form').clone();
			var $len = parseInt($('.column-form').length);

			$(sss).find('.attrId').attr('name', 'attrName[' + $len + '][]');
			$(".addedField").append(sss);
			sss.find('.removeContentDiv').css('display', 'initial')
			sss.find('.copyFormData').css('display', 'none')
		})

		$(document).on('click', '.removeFormData', function () {
			var sss = $(this).closest('.row').remove();
		});

	</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/user/store/productStock/stockCreate.blade.php ENDPATH**/ ?>