<?php $__env->startSection('page_title', __('Product Details')); ?>
<?php $__env->startSection('content'); ?>
	<!-- product details section -->
	<section class="product-details-section">
		<div class="container">
			<div class="row g-4">
				<div class="col-lg-6">
					<div id="mainCarousel" class="carousel mx-auto">
						<?php $__empty_1 = true; $__currentLoopData = $product->productImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productImage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
							<div
								class="carousel__slide"
								data-src="<?php echo e(getFile(config('location.product.path').$productImage->image)); ?>"
								data-fancybox="gallery"
								data-caption="">
								<img class="img-fluid"
									 src="<?php echo e(getFile(config('location.product.path').$productImage->image)); ?>"/>
							</div>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
						<?php endif; ?>
					</div>

					<div id="thumbCarousel" class="carousel max-w-xl mx-auto mb-5">
						<?php $__empty_1 = true; $__currentLoopData = $product->productImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productImage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
							<div class="carousel__slide">
								<img class="panzoom__content img-fluid"
									 src="<?php echo e(getFile(config('location.product.path').'thumb_'.$productImage->image)); ?>"/>
							</div>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
						<?php endif; ?>
					</div>
				</div>
				<div class="col-lg-6">
					<div class="product-info">
						<h3 class="title"><?php echo e($product->name); ?> <sup><span class="tag stock " id="stock">
                                <i class="fa fa-spinner fa-spin loader" aria-hidden="false"></i>
						</span></sup></h3>
						<span class="tag"><?php echo app('translator')->get('Available'); ?></span>
						<?php if($product->tag): ?>
							<span class="tag"><?php echo e($product->tag); ?></span>
						<?php endif; ?>
						<h4 class="price mt-4"><?php echo app('translator')->get('Price:'); ?> <?php echo e(optional($product->user->StoreCurrency)->symbol); ?><?php echo e(getAmount($product->price)); ?></h4>
						<p class="description my-4">
							<?php echo e($product->description); ?>

						</p>
						<p><?php echo app('translator')->get('SKU:'); ?> <?php echo e($product->sku); ?></p>
						<p><?php echo app('translator')->get('Category:'); ?> <?php echo e(optional($product->category)->name); ?></p>
						<div class="d-flex align-items-center">
							<h5><?php echo app('translator')->get('Quantity:'); ?></h5>
							<div class="quantity ms-2">
								<button class="btn-inc-dec qty decrement">-</button>
								<input type="text" class="form-control qty counter" value="1" readonly/>
								<button class="btn-inc-dec qty increment">+</button>
							</div>
						</div>
						<?php $__empty_1 = true; $__currentLoopData = $attributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
							<div class="d-flex align-items- attribute-length">
								<h5 class="pt-2 me-2"><?php echo e(optional($attr->attribute)->name); ?>:</h5>
								<div class="radio-box mb-3">
									<?php $__empty_2 = true; $__currentLoopData = optional($attr->attribute)->attrLists; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $attrList): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
										<span class="tag-item">
                                          <input type="radio" class="btn-check attribute-select"
												 name="attr<?php echo e($attr->id); ?>"
												 id="<?php echo e($attr->id); ?><?php echo e($key); ?>"
												 autocomplete="off"
												 value="<?php echo e($attrList->id); ?>"
												 <?php if($key == 0): ?> checked <?php endif; ?> />
                                          <label class="btn btn-primary"
												 for="<?php echo e($attr->id); ?><?php echo e($key); ?>"> <?php echo e($attrList->name); ?></label>
                                        </span>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
									<?php endif; ?>
								</div>
							</div>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
						<?php endif; ?>
						<div id="shareBlock"><h5><?php echo app('translator')->get('Share now:'); ?></h5></div>
						<button data-id="<?php echo e($product->id); ?>"
								data-name="<?php echo e($product->name); ?>" data-price="<?php echo e($product->price); ?>"
								data-image="<?php echo e(getFile(config('location.product.path').$product->thumbnail)); ?>"
								data-currency="<?php echo e(optional($product->user->StoreCurrency)->symbol); ?>"
								data-attributes=""
								data-route="<?php echo e(route('product.attributes.list')); ?>"
								data-quantity="1"
								class="btn-custom mt-4 addToCart cartCount"><?php echo app('translator')->get('Add to cart'); ?></button>
					</div>
				</div>
			</div>
		</div>
		<div class="row justify-content-center">
			<div class="col-lg-8">
				<div class="product-description">
					<div class="navigator">
						<button tab-id="tab1" class="tab active"><?php echo app('translator')->get('Description'); ?></button>
						<button tab-id="tab2" class="tab"><?php echo app('translator')->get('Instruction'); ?></button>
					</div>
					<!-- description -->
					<div id="tab1" class="content active">
						<h4><?php echo app('translator')->get('Description Area'); ?></h4>
						<?php echo e($product->description); ?>

					</div>
					<!-- review -->
					<div id="tab2" class="content"><?php echo e($product->instruction); ?></div>
				</div>
			</div>
		</div>
	</section>
	<?php if(count($popularProducts)>0): ?>
		<!-- popular products section -->
		<section class="popular-products-section">
			<div class="container">
				<div class="row">
					<div class="col-12">
						<div class="header-text text-center">
							<h2><?php echo app('translator')->get('Popular Items'); ?></h2>
							<p class="mx-auto"><?php echo app('translator')->get('Our special offered items price.'); ?></p>
						</div>
					</div>
				</div>
				<div class="row">
					<div class="col">
						<div class="popular-products-carousel owl-carousel">
							<?php $__empty_1 = true; $__currentLoopData = $popularProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $popularProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
								<div class="product-box">
									<div class="img-box">
										<img
											src="<?php echo e(getFile(config('location.product.path').$popularProduct->thumbnail)); ?>"
											class="img-fluid" alt="<?php echo e($popularProduct->name); ?>"/>
									</div>
									<div class="text-box">
										<a href="<?php echo e(route('public.product.details',[$link,@slug($popularProduct->name),$popularProduct->id])); ?>"
										   class="title"><?php echo e($popularProduct->name); ?></a>
										<div class="d-flex justify-content-between align-items-center">
											<h4 class="price mb-0"><?php echo e(optional($product->user->StoreCurrency)->symbol); ?><?php echo e($popularProduct->price); ?></h4>
											<button class="add-to-cart">
												<i class="fal fa-shopping-cart"></i>
											</button>
										</div>
									</div>
								</div>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
							<?php endif; ?>
						</div>
					</div>
				</div>
			</div>
		</section>
	<?php endif; ?>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('extra_scripts'); ?>
	<script>
		"use strict";
		var stockQty = 0;
		var value = 1;
		$(".counter").val(value);

		$(document).on("click", ".increment", function () {
			value = parseInt(value + 1);
			if (value > stockQty) {
				Notiflix.Notify.Warning("<?php echo app('translator')->get('Out Of Stock'); ?>");
				value = parseInt(value - 1);
			} else {
				$(".counter").val(value);
				$('.cartCount').data('quantity', value);
			}
		});
		$(document).on("click", ".decrement", function () {
			if (value > 1) {
				value = parseInt(value - 1);
				$(".counter").val(value);
				$('.cartCount').data('quantity', value);
			} else {
				value = 1;
				$(".counter").val(value);
				$('.cartCount').data('quantity', value);
			}
		});

		// Get Product Info
		getStock();
		$(".attribute-select").on('change', function () {
			$('#stock').html(`<i class="fa fa-spinner fa-spin loader" aria-hidden="false"></i>`)
			getStock();
		});

		function getStock() {
			let selectedIds = [];
			let attributeLength = $('.attribute-length').length;
			let productId = '<?php echo e($product->id); ?>';

			$($(".attribute-select:checked")).each(function (key, value) {
				selectedIds.push($(value).val());
				$('.cartCount').data('attributes', selectedIds);
			});

			if (selectedIds.length != attributeLength) {
				return false;
			}

			$.ajax({
				url: "<?php echo e(route('public.stock.check')); ?>",
				method: "get",
				data: {
					productId: productId,
					attributeIds: selectedIds,
				},
				success: function (res) {
					stockQty = res.stock;
					if (res.message) {
						$('#stock').html(`${res.message}<i class=" loader" style="font-size:24px" aria-hidden="false"></i>`)
						$('.loader').removeClass('fa fa-spinner fa-spin');
					}

					if (res.status == false) {
						$('.qty').attr('disabled', 'true');
						$(".addToCart").attr('disabled', true);
						$('#stock').addClass('OutStock')
						Notiflix.Notify.Failure("Out of stock");
					} else {
						$('.qty').prop('disabled', false)
						$(".addToCart").attr('disabled', false);
						$('#stock').removeClass('OutStock')
					}
					let qty = $(".counter").val();
				}
			});
		}

		$(".addToCart").on('click', function () {
			productCheck();
		});

		function productCheck() {
			var cart = JSON.parse(sessionStorage.getItem('shoppingCart'));
			var storage_qty = 0;
			for (let obj in cart) {
				var storage_qty = cart[obj].count;
			}

			let selectedIds = [];
			let productId = '<?php echo e($product->id); ?>';

			let quantity = $(this).data('quantity');
			let attributeLength = $('.attribute-length').length;

			$($(".attribute-select:checked")).each(function (key, value) {
				selectedIds.push($(value).val());
			});
			if (selectedIds.length != attributeLength) {
				return false;
			}

			$.ajax({
				url: "<?php echo e(route('product.attr.check')); ?>",
				method: "get",
				data: {
					productId: productId,
					attributeIds: selectedIds,
					quantity: quantity,
					storage_qty: storage_qty,
				},
				success: function (res) {
					if (!res.status) {
						$(".addToCart").attr('disabled', true);
					}
				}
			});
		}
	</script>
	<?php if($errors->any()): ?>
		<?php
			$collection = collect($errors->all());
			$errors = $collection->unique();
		?>
		<script>
			"use strict";
			<?php $__currentLoopData = $errors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			Notiflix.Notify.Failure("<?php echo e(trans($error)); ?>");
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		</script>
	<?php endif; ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('user.layouts.storeMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/user/store/shop/productDetails.blade.php ENDPATH**/ ?>