<?php $__env->startSection('page_title', __('Inactive User List')); ?>

<?php $__env->startSection('content'); ?>
<div class="main-content">
	<section class="section">
		<div class="section-header">
			<h1><?php echo app('translator')->get('Inactive User List'); ?></h1>
			<div class="section-header-breadcrumb">
				<div class="breadcrumb-item active">
					<a href="<?php echo e(route('admin.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
				</div>
				<div class="breadcrumb-item"><?php echo app('translator')->get('Inactive User List'); ?></div>
			</div>
		</div>

		<div class="row mb-3">
			<div class="container-fluid" id="container-wrapper">
				<div class="row">
					<div class="col-lg-12">
						<div class="card mb-4 card-primary shadow-sm">
							<div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
								<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Search'); ?></h6>
							</div>
							<div class="card-body">
								<form action="<?php echo e(route('inactive.user.search')); ?>" method="get">
									<?php echo $__env->make('admin.user.searchForm', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
								</form>
							</div>
						</div>
					</div>
				</div>
				<div class="row">
					<div class="col-lg-12">
						<div class="card mb- card-primary shadow">
							<div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
								<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('User List'); ?></h6>
								<a href="<?php echo e(route('send.mail.user')); ?>" class="btn btn-sm btn-outline-primary"><i class="fas fa-envelope"></i> <?php echo app('translator')->get('Send Mail to All'); ?></a>
							</div>
							<div class="card-body">
								<div class="table-responsive">
									<table class="table table-striped table-hover align-items-center table-borderless">
										<thead class="thead-light">
										<tr>
											<th><?php echo app('translator')->get('SL'); ?></th>
											<th><?php echo app('translator')->get('Name'); ?></th>
											<th><?php echo app('translator')->get('Phone'); ?></th>
											<th><?php echo app('translator')->get('Email'); ?></th>
											<th><?php echo app('translator')->get('Join date'); ?></th>
											<th><?php echo app('translator')->get('Last login'); ?></th>
											<th><?php echo app('translator')->get('Action'); ?></th>
										</tr>
										</thead>
										<tbody>
										<?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
											<tr>
												<td data-label="SL">
													<?php echo e(loopIndex($users) + $key); ?>

												</td>

												<td data-label="<?php echo app('translator')->get('Name'); ?>">
													<div class="d-lg-flex d-block align-items-center ">
														<div class="mr-3"><img src="<?php echo e($value->profilePicture()); ?>" alt="user"
																			   class="rounded-circle" width="35" data-toggle="tooltip" title="" data-original-title="<?php echo e($value->name); ?>">
														</div>
														<div class="d-inline-flex d-lg-block align-items-center">
															<p class="text-dark mb-0 font-16 font-weight-medium"><?php echo e($value->name); ?></p>
															<span class="text-muted font-14 ml-1"><?php echo e('@'.$value->username); ?></span>
														</div>
													</div>
												</td>

												<td data-label="<?php echo app('translator')->get('Phone'); ?>"><?php echo e(__(optional($value->profile)->phone ?? __('N/A'))); ?></td>
												<td data-label="<?php echo app('translator')->get('Email'); ?>"><?php echo e(__($value->email)); ?></td>
												<td data-label="<?php echo app('translator')->get('Join date'); ?>"><?php echo e(__(date('d/m/Y - H:i',strtotime($value->created_at)))); ?></td>
												<td data-label="<?php echo app('translator')->get('Last login'); ?>"><?php echo e((optional($value->profile)->last_login_at) ? __(date('d/m/Y - H:i',strtotime($value->profile->last_login_at))) : __('N/A')); ?></td>
												<td data-label="<?php echo app('translator')->get('Action'); ?>">
													<a href="<?php echo e(route('user.edit',$value)); ?>" class="btn btn-sm btn-outline-primary mb-1"><i class="fas fa-user-edit"></i> <?php echo app('translator')->get('Edit'); ?></a>
													<a href="<?php echo e(route('send.mail.user',$value)); ?>" class="btn btn-sm btn-outline-primary mb-1"><i class="fas fa-envelope"></i> <?php echo app('translator')->get('Send mail'); ?></a>
													<a href="<?php echo e(route('user.asLogin',$value)); ?>" class="btn btn-sm btn-outline-dark mb-1"><i class="fas fa-sign-in-alt"></i> <?php echo app('translator')->get('Login'); ?></a>
												</td>
											</tr>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
											<tr>
												<th colspan="100%" class="text-center"><?php echo app('translator')->get('No data found'); ?></th>
											</tr>
										<?php endif; ?>
										</tbody>
									</table>
								</div>
								<div class="card-footer"><?php echo e($users->links()); ?></div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

	</section>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/admin/user/inactive.blade.php ENDPATH**/ ?>