<?php $__env->startSection('page_title',__(ucfirst(kebab2Title($content)))); ?>

<?php $__env->startSection('content'); ?>
	<div class="main-content">
		<section class="section">
			<div class="section-header">
				<h1><?php echo app('translator')->get(kebab2Title($content)); ?></h1>
				<div class="section-header-breadcrumb">
					<div class="breadcrumb-item active">
						<a href="<?php echo e(route('admin.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
					</div>
					<div class="breadcrumb-item"><?php echo app('translator')->get(kebab2Title($content)); ?></div>
				</div>
			</div>

			<div class="row mb-3">
				<div class="container-fluid" id="container-wrapper">
					<div class="row justify-content-md-center">
						<div class="col-lg-12">
							<div class="card mb-4 card-primary shadow">
								<div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
									<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get(ucfirst(kebab2Title($content))); ?></h6>
									<span>
										<a href="<?php echo e(route('content.create',$content)); ?>" class="btn btn-sm btn-outline-primary"><?php echo app('translator')->get('Add New'); ?></a>
									</span>
								</div>
								<div class="card-body">
									<div class="table-responsive">
										<table class="table table-striped table-hover align-items-center table-flush">
											<thead class="thead-light">
											<tr>
												<th><?php echo app('translator')->get('Title'); ?></th>
												<th><?php echo app('translator')->get('Action'); ?></th>
											</tr>
											</thead>
											<tbody>
											<?php $__currentLoopData = $contents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<tr>
													<td data-label="<?php echo app('translator')->get('Title'); ?>">
														<?php if(isset($value->contentDetails[0])): ?>
															<?php echo e(__(optional(optional($value->contentDetails[0])->description)->title ?? __('N/A'))); ?>

														<?php else: ?>
															<?php echo e(optional(optional($value->contentMedia)->description)->social_icon ?? __('N/A')); ?>

														<?php endif; ?>
													</td>
													<td data-label="<?php echo app('translator')->get('Action'); ?>">
														<a href="<?php echo e(route('content.show',$value)); ?>" class="btn btn-sm btn-outline-primary"><i class="fas fa-edit"></i> <?php echo app('translator')->get('Edit'); ?></a>
														<a href="javascript:void(0)"
														   data-route="<?php echo e(route('content.delete',$value->id)); ?>"
														   data-toggle="modal"
														   data-target="#delete-modal"
														   class="btn btn-outline-danger btn-sm delete"
														><i class="fas fa-trash-alt"></i> <?php echo app('translator')->get('Delete'); ?></a>
													</td>
												</tr>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
											</tbody>
										</table>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

		</section>
	</div>

	<div id="delete-modal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="primary-header-modalLabel" aria-hidden="true">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title" id="primary-header-modalLabel"><?php echo app('translator')->get('Delete Confirmation'); ?></h5>
					<button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
				</div>
				<div class="modal-body">
					<p><?php echo app('translator')->get('Are you sure to delete this?'); ?></p>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-dark" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
					<form action="" method="post" class="deleteRoute">
						<?php echo csrf_field(); ?>
						<?php echo method_field('delete'); ?>
						<button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Yes'); ?></button>
					</form>
				</div>
			</div>
		</div>
	</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
	<script>
		'use strict'
		$(document).ready(function () {
			$(document).on('click', '.delete', function () {
				let url = $(this).data('route');
				$('.deleteRoute').attr('action', url);
			})
		});
	</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/admin/content/index.blade.php ENDPATH**/ ?>