<?php $__env->startSection('page_title',__('Role List')); ?>

<?php $__env->startSection('content'); ?>
	<div id="role-permission-app">
		<div class="main-content">
			<section class="section">
				<div class="section-header">
					<h1><?php echo app('translator')->get('Role List'); ?></h1>
					<div class="section-header-breadcrumb">
						<div class="breadcrumb-item active">
							<a href="<?php echo e(route('admin.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
						</div>
						<div class="breadcrumb-item"><?php echo app('translator')->get('Role List'); ?></div>
					</div>
				</div>

				<div class="row mb-3">
					<div class="container-fluid" id="container-wrapper">
						<div class="row">
							<div class="col-lg-12">
								<div class="card mb-4 card-primary shadow">
									<div
										class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
										<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Role List'); ?></h6>
										<button class="btn btn-sm btn-primary" data-target="#add-modal"
												data-toggle="modal" @click="makeDataEmpty"><?php echo app('translator')->get('Add New'); ?></button>
									</div>
									<div class="card-body">
										<div class="table-responsive">
											<table
												class="table table-striped table-hover align-items-center table-borderless">
												<thead class="thead-light">
												<tr>
													<th><?php echo app('translator')->get('SL.'); ?></th>
													<th><?php echo app('translator')->get('Name'); ?></th>
													<th><?php echo app('translator')->get('Status'); ?></th>
													<th><?php echo app('translator')->get('Action'); ?></th>
												</tr>
												</thead>
												<tbody>
												<?php $__empty_1 = true; $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
													<tr>
														<td data-label="<?php echo app('translator')->get('SL.'); ?>"><?php echo e(++$key); ?></td>
														<td data-label="<?php echo app('translator')->get('Name'); ?>"><?php echo e($value->name); ?></td>
														<td data-label="<?php echo app('translator')->get('Status'); ?>">
															<?php if($value->status == 1): ?>
																<span class="badge badge-success"><?php echo app('translator')->get('Active'); ?></span>
															<?php else: ?>
																<span
																	class="badge badge-danger"><?php echo app('translator')->get('Inactive'); ?></span>
															<?php endif; ?>
														</td>
														<td data-label="<?php echo app('translator')->get('Action'); ?>">
															<button
																class="btn btn-sm btn-outline-info"
																data-target="#editModal" data-toggle="modal"
																data-resource="<?php echo e($value); ?>"
																@click="editRole(<?php echo e($value); ?>)"
																class="editRole"><?php echo app('translator')->get('Edit'); ?></button>
															<button
																class="btn btn-sm btn-outline-danger notiflix-confirm"
																data-target="#delete-modal"
																data-toggle="modal"
																data-route="<?php echo e(route('admin.role.delete',$value->id)); ?>">
																<?php echo app('translator')->get('Delete'); ?></button>
														</td>
													</tr>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
													<tr>
														<th colspan="100%"
															class="text-center"><?php echo app('translator')->get('No data found'); ?></th>
													</tr>
												<?php endif; ?>
												</tbody>
											</table>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</section>
		</div>
		
		<div id="add-modal" class="modal fade" data-backdrop="static" tabindex="-1" role="dialog"
			 aria-labelledby="primary-header-modalLabel"
			 aria-hidden="true">
			<div class="modal-dialog">
				<div class="modal-content">
					<div class="modal-header">
						<h4 class="modal-title text-dark font-weight-bold"
							id="primary-header-modalLabel"><?php echo app('translator')->get('Add Roles'); ?></h4>
						<button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
					</div>
					<form>
						<div class="modal-body">
							<div class="col-12">
								<label for=""><?php echo app('translator')->get('Name'); ?></label>
								<input
									type="text"
									class="form-control" v-model="item.name"
									placeholder="<?php echo app('translator')->get('Name'); ?>"/>
								<span class="text-danger name-error"></span>
							</div>
							<div class="col-md-12 my-3">
								<label for=""><?php echo app('translator')->get('Status'); ?> </label>
								<div class="selectgroup w-100">
									<label class="selectgroup-item">
										<input type="radio" v-model="item.status" value="0" class="selectgroup-input">
										<span class="selectgroup-button"><?php echo app('translator')->get('OFF'); ?></span>
									</label>
									<label class="selectgroup-item">
										<input type="radio" v-model="item.status" value="1" class="selectgroup-input"
											   :checked="item.status == 1">
										<span class="selectgroup-button"><?php echo app('translator')->get('ON'); ?></span>
									</label>
								</div>
							</div>
							<div class="card mb-4 card-primary shadow">
								<div class="card-header">
									<div class="title">
										<h5><?php echo app('translator')->get('Accessibility'); ?></h5>
									</div>
								</div>
								<div class="card-body">
									<?php if(config('permissionList')): ?>
										<div class="row mt-3">
											<?php $__currentLoopData = config('permissionList'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<div class="input-box col-md-6 mt-3">
													<div class="form-check form-switch">
														<input class="form-check-input" type="checkbox"
															   v-model="item.permissions"
															   value="<?php echo e($item); ?>" role="switch"
															   id="flexSwitchCheckDefault"/>
														<label class="form-check-label"
															   for="flexSwitchCheckDefault"><?php echo e(str_replace('_',' ',ucfirst($key))); ?></label>
													</div>
												</div>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										</div>
									<?php endif; ?>
								</div>
								<span class="text-danger mb-2 permissions-error"></span>
							</div>
						</div>
						<div class="modal-footer">
							<button type="button" class="btn btn-dark" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
							<button type="button" class="btn btn-primary"
									@click.prevent="rolePermissionSubmit"><?php echo app('translator')->get('save'); ?></button>
						</div>
					</form>
				</div>
			</div>
		</div>

		
		<div id="editModal" class="modal fade" tabindex="-1" role="dialog"
			 aria-labelledby="primary-header-modalLabel"
			 aria-hidden="true">
			<div class="modal-dialog">
				<div class="modal-content">
					<div class="modal-header">
						<h4 class="modal-title text-dark font-weight-bold"
							id="primary-header-modalLabel"><?php echo app('translator')->get('Update Roles'); ?></h4>
						<button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
					</div>
					<form>
						<div class="modal-body">
							<input type="hidden" v-model="item.id" class="editRoleId" value="">
							<div class="col-12">
								<label for=""><?php echo app('translator')->get('Name'); ?></label>
								<input
									type="text"
									class="form-control editRoleName"
									v-model="item.name"
									placeholder="<?php echo app('translator')->get('Name'); ?>"/>
								<span class="text-danger name-error"></span>
							</div>
							<div class="col-md-12 my-3">
								<label for=""><?php echo app('translator')->get('Status'); ?> </label>
								<div class="selectgroup w-100">
									<label class="selectgroup-item">
										<input type="radio" v-model="item.status" value="0" class="selectgroup-input"
											   :checked="item.status == 0">
										<span class="selectgroup-button"><?php echo app('translator')->get('OFF'); ?></span>
									</label>
									<label class="selectgroup-item">
										<input type="radio" v-model="item.status" value="1" class="selectgroup-input"
											   :checked="item.status == 1">
										<span class="selectgroup-button"><?php echo app('translator')->get('ON'); ?></span>
									</label>
								</div>
							</div>
							<div class="card mb-4 card-primary shadow">
								<div class="card-header">
									<div class="title">
										<h5><?php echo app('translator')->get('Accessibility'); ?></h5>
									</div>
								</div>
								<div class="card-body">
									<?php if(config('permissionList')): ?>
										<div class="row">
											<?php $__currentLoopData = config('permissionList'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<div class="input-box col-md-6 mt-3">
													<div class="form-check form-switch">
														<input class="form-check-input" type="checkbox"
															   v-model="item.permissions"
															   value="<?php echo e($item); ?>" role="switch"
															   id="flexSwitchCheckDefault"/>
														<label class="form-check-label"
															   for="flexSwitchCheckDefault"><?php echo e(str_replace('_',' ',ucfirst($key))); ?></label>
													</div>
												</div>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										</div>
									<?php endif; ?>
								</div>
								<span class="text-danger mb-2 permissions-error"></span>
							</div>
							<div class="modal-footer">
								<button type="button" class="btn btn-dark" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
								<button type="button" @click.prevent="rolePermissionUpdate"
										class="btn btn-primary"><?php echo app('translator')->get('update'); ?></button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>

		
		<div id="delete-modal" class="modal fade" tabindex="-1" role="dialog"
			 aria-labelledby="primary-header-modalLabel"
			 aria-hidden="true">
			<div class="modal-dialog">
				<div class="modal-content">
					<div class="modal-header">
						<h4 class="modal-title text-dark font-weight-bold"
							id="primary-header-modalLabel"><?php echo app('translator')->get('Delete Confirmation'); ?></h4>
						<button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
					</div>
					<form action="" method="post" class="deleteRoute">
						<?php echo csrf_field(); ?>
						<?php echo method_field('delete'); ?>
						<div class="modal-body">
							<p><?php echo app('translator')->get('Are you sure want to delete this roles'); ?></p>
						</div>
						<div class="modal-footer">
							<button type="button" class="btn btn-dark" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
							<button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Confirm'); ?></button>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('extra_scripts'); ?>
	<script>
		'use strict'

		$(document).on('click', '.notiflix-confirm', function () {
			var route = $(this).data('route');
			$('.deleteRoute').attr('action', route)
		});

		var newApp = new Vue({
			el: "#role-permission-app",
			data: {
				item: {
					name: "",
					id: "",
					status: "",
					permissions: [],
				}
			},
			mounted() {
				this.item.status = 1;
			},
			methods: {
				rolePermissionSubmit() {
					var $url = '<?php echo e(route('admin.role.create')); ?>'
					axios.post($url, this.item)
						.then(function (response) {
							if (response.data.result) {
								location.reload();
							}
						})
						.catch(function (error) {
							let errors = error.response.data;
							errors = errors.errors
							for (let err in errors) {
								let selector = document.querySelector(`.${err}-error`);
								if (selector) {
									selector.innerText = `${errors[err]}`;
								}
							}
						});
				},
				makeDataEmpty() {
					this.item.name = "";
					this.item.id = "";
					this.item.permissions = [];
				},
				editRole(obj) {
					this.makeDataEmpty();
					this.item.name = obj.name;
					this.item.id = obj.id;
					this.item.status = obj.status;
					this.item.permissions = obj.permission;
					if (0 < obj.permission.length) {
						obj.permission.map(function (obj, i) {
							$(`.permission-check[value="${obj}"]`).attr('checked', 'checked');
						});
					}
				},
				rolePermissionUpdate() {
					var $url = '<?php echo e(route('admin.role.update')); ?>'
					axios.post($url, this.item)
						.then(function (response) {
							if (response.data.result) {
								location.reload();
							}
						})
						.catch(function (error) {
							let errors = error.response.data;
							errors = errors.errors
							for (let err in errors) {
								let selector = document.querySelector(`.${err}-error`);
								if (selector) {
									selector.innerText = `${errors[err]}`;
								}
							}
						});
				},
			}
		})
	</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/admin/role_permission/roleList.blade.php ENDPATH**/ ?>