<?php $__env->startSection('page_title',__('2 Step Security')); ?>

<?php $__env->startSection('content'); ?>
	<div class="main-content">
		<section class="section">
			<div class="section-header">
				<h1><?php echo app('translator')->get('2 Step Security'); ?></h1>
				<div class="section-header-breadcrumb">
					<div class="breadcrumb-item active">
						<a href="<?php echo e(route('user.dashboard')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
					</div>
					<div class="breadcrumb-item"><?php echo app('translator')->get('2 Step Security'); ?></div>
				</div>
			</div>
			<div class="row justify-content-between">
				<div class="col-lg-6">
					<div class="card mb-4 card-primary shadow">
						<?php if(auth()->user()->two_fa): ?>
							<div class="col-md-12 shadow-none p-3 bg-gradient rounded">
								<div class="contact-box">
									<div class="card-header">
										<h5 class="card-title"><?php echo app('translator')->get('Two Factor Authenticator'); ?></h5>
									</div>

									<div class="form-group">
										<div class="form-group form-box">
											<div class="input-group append">
												<input type="text" value="<?php echo e($previousCode); ?>" class="form-control"
													   id="referralURL" readonly>
												<button class="btn btn-success py-0 copytext" type="button" id="copyBoard"
														onclick="copyFunction()"><i
														class="fa fa-copy"></i> <?php echo app('translator')->get('Copy'); ?>
												</button>
											</div>
										</div>
									</div>
									<div class="form-group mx-auto text-center my-3">
										<img class="mx-auto w-30" src="<?php echo e($previousQR); ?>">
									</div>

									<div class="form-group mx-auto text-center">
										<a href="javascript:void(0)" class="btn btn-primary btn-sm btn-block" data-toggle="modal"
										   data-target="#disableModal"><?php echo app('translator')->get('Disable Two Factor Authenticator'); ?></a>
									</div>
								</div>
							</div>
						<?php else: ?>
							<div class="col-md-12 shadow-none p-3 bg-gradient rounded">
								<div class="contact-box">
									<div class="card-header">
										<h5 class="card-title"><?php echo app('translator')->get('Two Factor Authenticator'); ?></h5>
									</div>

									<div class="form-group form-box">
										<div class="input-group append">
											<input type="text" value="<?php echo e($secret); ?>" class="form-control"
												   id="referralURL" readonly>
											<button class="btn btn-success py-0 copytext" type="button" id="copyBoard"
													onclick="copyFunction()"><i class="fa fa-copy"></i> <?php echo app('translator')->get('Copy'); ?>
											</button>
										</div>
									</div>
									<div class="form-group mx-auto text-center">
										<img class="w-30 mx-auto" src="<?php echo e($qrCodeUrl); ?>">
									</div>

									<div class="form-group mx-auto text-center">
										<a href="javascript:void(0)" class="btn btn-primary btn-block btn-sm mt-3" data-toggle="modal"
										   data-target="#enableModal"><?php echo app('translator')->get('Enable Two Factor Authenticator'); ?></a>
									</div>
								</div>

							</div>
						<?php endif; ?>
					</div>
				</div>

				<div class="col-lg-6">
					<div class="card mb-4 card-primary shadow">
						<div class="card-header">
							<h5 class="card-title"><?php echo app('translator')->get('Google Authenticator'); ?></h5>
						</div>
						<div class="card-body">

							<h6 class="text-uppercase my-3"><?php echo app('translator')->get('Use Google Authenticator to Scan the QR code  or use the code'); ?></h6>

							<p class="p-5"><?php echo app('translator')->get('Google Authenticator is a multifactor app for mobile devices. It generates timed codes used during the 2-step verification process. To use Google Authenticator, install the Google Authenticator application on your mobile device.'); ?></p>
							<div class="submit-btn-wrapper text-center text-md-left">
								<a class="btn btn-primary btn-sm btn-block"
								   href="https://play.google.com/store/apps/details?id=com.google.android.apps.authenticator2&hl=en"
								   target="_blank"><?php echo app('translator')->get('DOWNLOAD APP'); ?></a>
							</div>

						</div>
					</div>
				</div>

			</div>
		</section>
	</div>

	<div id="enableModal" class="modal fade" tabindex="-1" role="dialog"
		 aria-labelledby="primary-header-modalLabel"
		 aria-hidden="true">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title text-dark font-weight-bold"
						id="primary-header-modalLabel"><?php echo app('translator')->get('Verify Your OTP'); ?></h4>
					<button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
				</div>
				<form action="<?php echo e(route('user.twoStepEnable')); ?>" method="POST">
					<?php echo csrf_field(); ?>
					<div class="modal-body">
						<div class="form-group mt-3 security-block">
							<label for="Authenticator Code"><?php echo app('translator')->get('Authenticator Code'); ?></label>
							<input type="hidden" name="key" value="<?php echo e($secret); ?>">
							<div class="form-group">
								<input type="text" class="form-control" name="code"
									   placeholder="<?php echo app('translator')->get('Enter Google Authenticator Code'); ?>">
							</div>
						</div>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-dark" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
						<button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Verify'); ?></button>
					</div>
				</form>
			</div>
		</div>
	</div>

	<div id="disableModal" class="modal fade" tabindex="-1" role="dialog"
		 aria-labelledby="primary-header-modalLabel"
		 aria-hidden="true">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title text-dark font-weight-bold"
						id="primary-header-modalLabel"><?php echo app('translator')->get('Verify Your OTP to Disable'); ?></h4>
					<button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
				</div>
				<form action="<?php echo e(route('user.twoStepDisable')); ?>" method="POST">
					<?php echo csrf_field(); ?>
					<div class="modal-body">
						<div class="form-group mt-3 security-block">
							<label for="Authenticator Code"><?php echo app('translator')->get('Authenticator Code'); ?></label>
							<div class="form-group">
								<input type="text" class="form-control" name="code"
									   placeholder="<?php echo app('translator')->get('Enter Google Authenticator Code'); ?>">
							</div>
						</div>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-dark" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
						<button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Verify'); ?></button>
					</div>
				</form>
			</div>
		</div>
	</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('extra_scripts'); ?>
	<?php if($errors->any()): ?>
		<?php
			$collection = collect($errors->all());
			$errors = $collection->unique();
		?>
		<script>
			"use strict";
			<?php $__currentLoopData = $errors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			Notiflix.Notify.Failure("<?php echo e(trans($error)); ?>");
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		</script>
	<?php endif; ?>
	<script>
		function copyFunction() {
			var copyText = document.getElementById("referralURL");
			copyText.select();
			copyText.setSelectionRange(0, 99999);
			/*For mobile devices*/
			document.execCommand("copy");
			Notiflix.Notify.Success(`Copied: ${copyText.value}`);
		}
	</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/user/twoFA/index.blade.php ENDPATH**/ ?>