<?php $__env->startSection('page_title',__('Business Api key')); ?>

<?php $__env->startSection('content'); ?>
	<div class="main-content" id="api-app">
		<section class="section">
			<div class="section-header">
				<h1><?php echo app('translator')->get('Business Api key'); ?></h1>
				<div class="section-header-breadcrumb">
					<div class="breadcrumb-item active">
						<a href="<?php echo e(route('user.dashboard')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
					</div>
					<div class="breadcrumb-item"><?php echo app('translator')->get('Business Api key'); ?></div>
				</div>
			</div>
			<div class="row mb-3">
				<div class="container-fluid" id="container-wrapper">
					<div class="row justify-content-md-center">
						<div class="col-md-8">
							<div class="card mb-4 card-primary shadow">
								<div
									class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
									<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Business Api key'); ?></h6>
									<div class="selectgroup w-30">
										<label class="selectgroup-item">
											<input type="radio"
												   class="selectgroup-input" <?php echo e($user->mode == 0?'checked':''); ?>>
											<a href="<?php echo e(route('user.mode.change','test')); ?>"
											   class="selectgroup-button"><span><?php echo app('translator')->get('Test Mode'); ?></span></a>
										</label>
										<label class="selectgroup-item">
											<input type="radio"
												   class="selectgroup-input" <?php echo e($user->mode == 1?'checked':''); ?>>
											<a href="<?php echo e(route('user.mode.change','live')); ?>"
											   class="selectgroup-button"><span><?php echo app('translator')->get('Live Mode'); ?></span></a>
										</label>
									</div>
								</div>
								<div class="card-body">
									<form>
										<div class="row">
											<div class="col-md-6">
												<div class="form-group">
													<label for="Public Key"><?php echo app('translator')->get('Public Key:'); ?></label>
													<div class="input-group">
														<input type="text" name="public_key"
															   class="form-control"
															   value="<?php echo e($user->public_key); ?>" readonly>
														<div class="input-group-prepend">
															<button type="button"
																	class="btn btn-success py-0"
																	@click="copyPublicCode()"><?php echo app('translator')->get('Copy'); ?></button>
														</div>
													</div>
													<div class="invalid-feedback">
														<?php $__errorArgs = ['public_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
													</div>
												</div>
											</div>
											<div class="col-md-6">
												<div class="form-group">
													<label for="Public Key"><?php echo app('translator')->get('Secret Key:'); ?></label>
													<div class="input-group">
														<input type="text" name="secret_key" class="form-control"
															   value="<?php echo e($user->secret_key); ?>" readonly>
														<div class="input-group-prepend">
															<button type="button"
																	class="btn btn-success py-0"
																	@click="copySecretCode()"><?php echo app('translator')->get('Copy'); ?></button>
														</div>
													</div>
													<div class="invalid-feedback">
														<?php $__errorArgs = ['secret_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
													</div>
												</div>
											</div>
										</div>
										<button type="button" data-target="#generate" data-toggle="modal"
												class="btn btn-primary btn-sm btn-block"><?php echo app('translator')->get('Generate Api Key'); ?></button>
									</form>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
	</div>
	<div id="generate" class="modal fade" tabindex="-1" role="dialog"
		 aria-labelledby="primary-header-modalLabel"
		 aria-hidden="true">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title text-dark font-weight-bold"
						id="primary-header-modalLabel"><?php echo app('translator')->get('Re-Generate Confirmation '); ?></h4>
					<button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
				</div>
				<form action="<?php echo e(route('user.api.key')); ?>" method="post">
					<?php echo csrf_field(); ?>
					<div class="modal-body">
						<h5><?php echo app('translator')->get('Are you sure want generate new api key?'); ?></h5>
						<p><?php echo app('translator')->get('It may cause interrupt with your existing api request operations.'); ?></p>
						<div class="form-group mt-3 security-block">
							<label for="security_pin"><?php echo app('translator')->get('Security Pin'); ?></label>
							<input type="password" name="security_pin"
								   placeholder="<?php echo app('translator')->get('Please enter your security PIN'); ?>"
								   autocomplete="off"
								   value="<?php echo e(old('security_pin')); ?>"
								   class="form-control <?php $__errorArgs = ['security_pin'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
							<div class="invalid-feedback">
								<?php $__errorArgs = ['security_pin'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
							</div>
							<div class="valid-feedback"></div>
						</div>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-dark" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
						<button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Confirm'); ?></button>
					</div>
				</form>
			</div>
		</div>
	</div>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('extra_scripts'); ?>
	<script>
		'use script'
		var newApp = new Vue({
			el: "#api-app",
			data: {
				item: {
					public_key: '<?php echo e($user->public_key); ?>',
					secret_key: '<?php echo e($user->secret_key); ?>',
				},
			},
			mounted() {
			},
			methods: {
				copyPublicCode() {
					let text = this.item.public_key;
					navigator.clipboard.writeText(text);
					Notiflix.Notify.Success(`Copied: ${text}`);
				},
				copySecretCode() {
					let text = this.item.secret_key;
					navigator.clipboard.writeText(text);
					Notiflix.Notify.Success(`Copied: ${text}`);
				},
			},
		})
	</script>
	<?php if($errors->any()): ?>
		<?php
			$collection = collect($errors->all());
			$errors = $collection->unique();
		?>
		<script>
			"use strict";
			<?php $__currentLoopData = $errors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			Notiflix.Notify.Failure("<?php echo e(trans($error)); ?>");
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		</script>
	<?php endif; ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/user/api/index.blade.php ENDPATH**/ ?>