<?php $__env->startSection('page_title',__('Store Update')); ?>

<?php $__env->startSection('content'); ?>
	<div class="main-content" id="storeEdit">
		<section class="section">
			<div class="section-header">
				<h1><?php echo app('translator')->get('Store Update'); ?></h1>
				<div class="section-header-breadcrumb">
					<div class="breadcrumb-item active">
						<a href="<?php echo e(route('user.dashboard')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
					</div>
					<div class="breadcrumb-item"><?php echo app('translator')->get('Store Update'); ?></div>
				</div>
			</div>
			<div class="row mb-3">
				<div class="container-fluid" id="container-wrapper">
					<div class="row justify-content-md-center">
						<div class="col-md-12">
							<div class="card mb-4 card-primary shadow">
								<div
									class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
									<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Store Update'); ?></h6>
								</div>
								<div class="card-body">
									<form action="<?php echo e(route('store.edit',$store->id)); ?>" method="post"
										  enctype="multipart/form-data">
										<?php echo csrf_field(); ?>
										<div class="row">
											<div class="col-md-4">
												<div class="form-group">
													<label for="Store Name"><?php echo app('translator')->get('Store Name'); ?> <sup
															class="text-danger">*</sup></label>
													<input type="text"
														   name="name"
														   value="<?php echo e($store->name); ?>"
														   class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
														   autocomplete="off" required>
													<div class="invalid-feedback">
														<?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
													</div>
												</div>
											</div>
											<div class="col-md-4">
												<div class="form-group">
													<label for="Shipping Status"><?php echo app('translator')->get('Shipping Charge'); ?></label>
													<select name="shipping_charge"
															class="form-control form-control-sm">
														<option
															value="1" <?php echo e($store->shipping_charge == '1' ? 'selected':''); ?>><?php echo app('translator')->get('Active'); ?></option>
														<option
															value="0" <?php echo e($store->shipping_charge == '0' ? 'selected':''); ?>><?php echo app('translator')->get('Inactive'); ?></option>
													</select>
													<div class="invalid-feedback">
														<?php $__errorArgs = ['shipping_charge'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
													</div>
												</div>
											</div>
											<div class="col-md-4">
												<div class="form-group">
													<label for="Delivery Note"><?php echo app('translator')->get('Delivery Note'); ?></label>
													<select name="delivery_note"
															class="form-control form-control-sm">
														<option
															value="disabled" <?php echo e($store->delivery_note == 'disabled' ? 'selected':''); ?>><?php echo app('translator')->get('Disable'); ?></option>
														<option
															value="enable" <?php echo e($store->delivery_note == 'enable' ? 'selected':''); ?>><?php echo app('translator')->get('Enable'); ?></option>
													</select>
													<div class="invalid-feedback">
														<?php $__errorArgs = ['delivery_note'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
													</div>
												</div>
											</div>
										</div>
										<div class="row">
											<div class="col-md-8">
												<label for="Image"><?php echo app('translator')->get('Store Link'); ?></label>
												<div class="input-group">
													<input type="text" value="<?php echo e(route('public.view')); ?>"
														   class="form-control" readonly>
													<div class="input-group-prepend width-50">
														<input type="text" v-on:keyup="storeLinkCheck" name="link"
															   value="<?php echo e($store->link); ?>"
															   class="form-control">
													</div>
												</div>
												<span class="text-danger float-right">{{ msg }}</span>
											</div>
											<div class="col-md-4">
												<div class="form-group">
													<label for="Status"><?php echo app('translator')->get('Status'); ?></label>
													<select name="status"
															class="form-control form-control-sm">
														<option
															value="1" <?php echo e($store->status == '1' ? 'selected':''); ?>><?php echo app('translator')->get('Active'); ?></option>
														<option
															value="0" <?php echo e($store->status == '0' ? 'selected':''); ?>><?php echo app('translator')->get('Inactive'); ?></option>
													</select>
													<div class="invalid-feedback">
														<?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
													</div>
												</div>
											</div>
										</div>
										<div class="row">
											<div class="col-md-6 mt-4">
												<label for="Image"><?php echo app('translator')->get('Store Image'); ?> <sup
														class="text-danger">* <?php echo app('translator')->get('size'); ?>
														= <?php echo e(config('location.store.size')); ?><?php echo app('translator')->get('px'); ?></sup></label>
												<div class="form-group mt-2">
													<div class="fileinput fileinput-new "
														 data-provides="fileinput">
														<div class="fileinput-new thumbnail withdraw-thumbnail"
															 data-trigger="fileinput">
															<img class="w-150px"
																 src="<?php echo e(getFile(config('location.store.path').$store->image)); ?>"
																 alt="...">
														</div>
														<div
															class="fileinput-preview fileinput-exists thumbnail wh-200-150"></div>
														<div class="img-input-div">
                                                                <span class="btn btn-info btn-file">
                                                                    <span
																		class="fileinput-new"> <?php echo app('translator')->get('Select Store Image'); ?></span>
                                                                    <span
																		class="fileinput-exists"> <?php echo app('translator')->get('Change'); ?></span>
                                                                    <input type="file" name="image" accept="image/*">
                                                                </span>
															<a href="#" class="btn btn-danger fileinput-exists"
															   data-dismiss="fileinput"> <?php echo app('translator')->get('Remove'); ?></a>
														</div>
														<div class="invalid-feedback">
															<?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
														</div>
													</div>
												</div>
											</div>
										</div>
										<div class="row">
											<div class="col-md-12">
												<div class="form-group">
													<label for="Store Description"><?php echo app('translator')->get('Store Description'); ?></label>
													<textarea name="short_description" rows="5"
															  class="form-control form-control-sm"><?php echo e($store->short_description); ?></textarea>
												</div>
											</div>
										</div>
										<button type="submit"
												class="btn btn-primary btn-sm btn-block"><?php echo app('translator')->get('Update store'); ?></button>
									</form>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

		</section>
	</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('extra_styles'); ?>
	<link rel="stylesheet" href="<?php echo e(asset('assets/dashboard/css/bootstrap-fileinput.css')); ?>">
<?php $__env->stopPush(); ?>
<?php $__env->startSection('scripts'); ?>
	<script src="<?php echo e(asset('assets/dashboard/js/bootstrap-fileinput.js')); ?>"></script>
	<script>
		'use strict'
		var newApp = new Vue({
			el: "#storeEdit",
			data: {
				link: {},
				msg: ''
			},
			mounted() {
			},
			methods: {
				storeLinkCheck(link) {
					let storeLink = this.link;
					storeLink.link = link.target.value;
					storeLink.storeId = '<?php echo e($store->id); ?>';
					var _this = this;
					axios.post("<?php echo e(route('store.link.check')); ?>", this.link)
						.then(function (response) {
							if (response.data.status == 'success') {
								_this.msg = response.data.msg;
							}
							if (response.data.status == 'notFound') {
								_this.msg = '';
							}
						})
						.catch(function (error) {
							let errors = error.response.data;
						});
				},
			},
		})

	</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/user/store/storeEdit.blade.php ENDPATH**/ ?>