<?php $__env->startSection('page_title', __('Languages')); ?>
<?php $__env->startSection('content'); ?>
	<div class="main-content">
		<section class="section">
			<div class="section-header">
				<h1><?php echo app('translator')->get('Languages'); ?></h1>
				<div class="section-header-breadcrumb">
					<div class="breadcrumb-item active">
						<a href="<?php echo e(route('admin.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
					</div>
					<div class="breadcrumb-item"><?php echo app('translator')->get('Languages'); ?></div>
				</div>
			</div>

			<div class="section-body">
				<div class="row mt-sm-4">
					<div class="col-12 col-md-4 col-lg-3">
						<?php echo $__env->make('admin.control_panel.components.sidebar', ['settings' => config('generalsettings.settings'), 'suffix' => 'Settings'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
					</div>
					<div class="col-12 col-md-8 col-lg-9">
						<div class="container-fluid" id="container-wrapper">
							<div class="row justify-content-md-center">
								<div class="col-lg-12">
									<div class="card mb-4 card-primary shadow">
										<div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
											<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Languages'); ?></h6>
											<span>
												<a href="<?php echo e(route('language.create')); ?>"
												class="btn btn-sm btn-outline-primary"><?php echo app('translator')->get('Add New'); ?></a>
											</span>
										</div>
										<div class="card-body">
											<div class="table-responsive">
												<table class="table table-hover align-items-center table-flush">
													<thead class="thead-light">
													<tr>
														<th><?php echo app('translator')->get('Name'); ?></th>
														<th><?php echo app('translator')->get('Short Name'); ?></th>
														<th><?php echo app('translator')->get('Status'); ?></th>
														<th><?php echo app('translator')->get('Action'); ?></th>
													</tr>
													</thead>
													<tbody>
													<?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
														<tr>
															<td data-label="<?php echo app('translator')->get('Name'); ?>">
																<div class="d-flex no-block align-items-center">
																	<div class="mr-2"><img class="img-profile-custom rounded-circle" src="<?php echo e(getFile(config('location.language.path'). $language->flag )); ?>" alt="<?php echo e(__($language->name)); ?>" class="rounded-circle" width="35" height="35"></div>
																	<div class="">
																		<p class="text-dark mb-0 font-weight-medium"><?php echo e(__($language->name)); ?></p>
																	</div>
																</div>
															</td>
															<td data-label="<?php echo app('translator')->get('Short Name'); ?>"><?php echo e(__($language->short_name)); ?></td>
															<td data-label="<?php echo app('translator')->get('Status'); ?>">
																<?php if($language->is_active): ?>
																	<span class="badge badge-info"><?php echo app('translator')->get('Active'); ?></span>
																<?php else: ?>
																	<span class="badge badge-warning"><?php echo app('translator')->get('Inactive'); ?></span>
																<?php endif; ?>
															</td>
															<td data-label="<?php echo app('translator')->get('Action'); ?>">
																<a href="<?php echo e(route('language.edit',$language)); ?>"
																class="btn btn-sm btn-outline-primary"><i
																			class="fas fa-edit"></i> <?php echo app('translator')->get('Edit'); ?></a>
																<a href="<?php echo e(route('language.keyword.edit',$language)); ?>"
																class="btn btn-sm btn-outline-primary m-1"><i
																			class="fas fa-code"></i> <?php echo app('translator')->get('Edit Keywords'); ?></a>
																<?php if(!$language->default_status): ?>
																	<a href="javascript:void(0)"
																	data-route="<?php echo e(route('language.delete',$language)); ?>"
																	data-toggle="modal"
																	data-target="#delete-modal"
																	class="btn btn-outline-danger btn-sm delete">
																		<i class="fas fa-trash-alt"></i> <?php echo app('translator')->get('Delete'); ?>
																	</a>
																<?php endif; ?>
															</td>
														</tr>
													<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
													</tbody>
												</table>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
	</div>

	<div id="delete-modal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="primary-header-modalLabel"
	aria-hidden="true">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title text-danger" id="primary-header-modalLabel"><?php echo app('translator')->get('Confirmation !'); ?></h4>
					<button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
				</div>
				<div class="modal-body text-center">
					<p><?php echo app('translator')->get('Are you sure to delete this?'); ?></p>
				</div>
				<form action="" method="post" class="deleteRoute">
					<?php echo csrf_field(); ?>
					<?php echo method_field('delete'); ?>
					<div class="modal-footer">
						<button type="button" class="btn btn-dark" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
						<button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Yes'); ?></button>
					</div>
				</form>
			</div>
		</div>
	</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        'use strict'
        $(document).ready(function () {
            $(document).on('click', '.delete', function () {
                let url = $(this).data('route');
                $('.deleteRoute').attr('action', url);
            })
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/admin/language/index.blade.php ENDPATH**/ ?>