<?php $__env->startSection('page_title', __('Orders List')); ?>
<?php $__env->startSection('content'); ?>
	<div class="main-content" id="store" v-cloak>
		<section class="section">
			<div class="section-header">
				<h1><?php echo app('translator')->get('Orders List'); ?></h1>
				<div class="section-header-breadcrumb">
					<div class="breadcrumb-item active">
						<a href="<?php echo e(route('user.dashboard')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
					</div>
					<div class="breadcrumb-item"><?php echo app('translator')->get('Orders List'); ?></div>
				</div>
			</div>
			<div class="section-body">
				<div class="row mt-sm-4">
					<div class="col-12 col-md-12 col-lg-12">
						<div class="container-fluid" id="container-wrapper">
							<div class="row">
								<div class="col-lg-12">
									<div class="card mb-4 card-primary shadow-sm">
										<div
											class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
											<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Search'); ?></h6>
										</div>
										<div class="card-body">
											<form action="<?php echo e(route('admin.order.list')); ?>" method="get">
												<?php echo $__env->make('admin.store.orderSearchForm', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
											</form>
										</div>
									</div>
								</div>
							</div>
							<div class="row justify-content-md-center">
								<div class="col-lg-12">
									<div class="card mb-4 card-primary shadow">
										<div
											class="card-header py-3 d-flex flex-wrap flex-row align-items-center justify-content-between">
											<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Orders List'); ?></h6>
											<div
												class="d-flex flex-wrap flex-row align-items-center justify-content-between">
												<a href="<?php echo e(route('admin.order.list','new-arrival')); ?>"
												   class="mr-2 btn btn-sm btn-round btn-outline-warning"><?php echo app('translator')->get('New Arrival'); ?></a>
												<a href="<?php echo e(route('admin.order.list','processing')); ?>"
												   class="mr-2 btn btn-sm btn-round btn-outline-info"><?php echo app('translator')->get('Processing'); ?></a>
												<a href="<?php echo e(route('admin.order.list','on-shipping')); ?>"
												   class="mr-2 btn btn-sm btn-round btn-outline-dark"><?php echo app('translator')->get('On Shipping'); ?></a>
												<a href="<?php echo e(route('admin.order.list','out-for-delivery')); ?>"
												   class="mr-2 btn btn-sm btn-round btn-outline-primary"><?php echo app('translator')->get('Out For Delivery'); ?></a>
												<a href="<?php echo e(route('admin.order.list','delivered')); ?>"
												   class="mr-2 btn btn-sm btn-round btn-outline-success"><?php echo app('translator')->get('Delivered'); ?></a>
												<a href="<?php echo e(route('admin.order.list','cancel')); ?>"
												   class="mr-2 btn btn-sm btn-round btn-outline-danger"><?php echo app('translator')->get('Cancel'); ?></a>
											</div>
										</div>
										<div class="card-body">
											<div class="table-responsive">
												<table
													class="table table-striped table-hover align-items-center table-flush"
													id="data-table">
													<thead class="thead-light">
													<tr>
														<th><?php echo app('translator')->get('#Order Number'); ?></th>
														<th><?php echo app('translator')->get('User'); ?></th>
														<th><?php echo app('translator')->get('Store'); ?></th>
														<th><?php echo app('translator')->get('Email'); ?></th>
														<th><?php echo app('translator')->get('Amount'); ?></th>
														<th><?php echo app('translator')->get('Shipping Charge'); ?></th>
														<th><?php echo app('translator')->get('Gateway'); ?></th>
														<th><?php echo app('translator')->get('Stage'); ?></th>
														<th><?php echo app('translator')->get('Action'); ?></th>
													</tr>
													</thead>
													<tbody>
													<?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
														<tr>
															<td data-label="<?php echo app('translator')->get('Order Number'); ?>">
																#<?php echo e($item->order_number); ?></td>
															<td data-label="<?php echo app('translator')->get('User'); ?>">
																<a href="<?php echo e(route('user.edit', $item->store->user_id)); ?>"
																   class="text-decoration-none">
																	<div class="d-lg-flex d-block align-items-center ">
																		<div class="mr-3"><img
																				src="<?php echo e(optional($item->store->user)->profilePicture()??asset('assets/upload/boy.png')); ?>"
																				alt="user"
																				class="rounded-circle" width="35"
																				data-toggle="tooltip" title=""
																				data-original-title="<?php echo e(optional($item->store->user)->name?? __('N/A')); ?>">
																		</div>
																		<div
																			class="d-inline-flex d-lg-block align-items-center">
																			<p class="text-dark mb-0 font-16 font-weight-medium"><?php echo e(Str::limit(optional($item->store->user)->name?? __('N/A'),20)); ?></p>
																			<span
																				class="text-muted font-14 ml-1"><?php echo e('@'.optional($item->store->user)->username?? __('N/A')); ?></span>
																		</div>
																	</div>
																</a>
															</td>
															<td data-label="Store">
																<a href="<?php echo e(route('store.edit',$item->store_id)); ?>"
																   class="text-decoration-none">
																	<div
																		class="d-inline-flex d-lg-block align-items-center">
																		<p class="text-dark mb-0 font-16 font-weight-medium">
																			<?php echo e(optional($item->store)->name); ?></p>
																	</div>
																</a>
															</td>
															<td data-label="<?php echo app('translator')->get('Email'); ?>"><?php echo e($item->email); ?></td>
															<td data-label="<?php echo app('translator')->get('Amount'); ?>"><span
																	class="text-dark font-weight-bold"><?php echo e(optional($item->store->user->storeCurrency)->symbol); ?><?php echo e(getAmount($item->total_amount,2)); ?></span>
															</td>
															<td data-label="<?php echo app('translator')->get('Shipping Charge'); ?>"><span
																	class="text-danger"><?php echo e(optional($item->store->user->storeCurrency)->symbol); ?><?php echo e(getAmount($item->shipping_charge)); ?></span>
															</td>
															<td data-label="<?php echo app('translator')->get('Gateway'); ?>"><?php echo e($item->gateway->name); ?></td>
															<td data-label="<?php echo app('translator')->get('Stage'); ?>">
																<?php if($item->stage == ''): ?>
																	<span
																		class="badge badge-warning"><?php echo app('translator')->get('New Arrival'); ?></span>
																<?php elseif($item->stage == 1): ?>
																	<span
																		class="badge badge-info"><?php echo app('translator')->get('Processing'); ?></span>
																<?php elseif($item->stage == 2): ?>
																	<span
																		class="badge badge-dark"><?php echo app('translator')->get('On Shipping'); ?></span>
																<?php elseif($item->stage == 3): ?>
																	<span
																		class="badge badge-primary"><?php echo app('translator')->get('Out For Delivery'); ?></span>
																<?php elseif($item->stage == 4): ?>
																	<span
																		class="badge badge-success"><?php echo app('translator')->get('Delivered'); ?></span>
																<?php elseif($item->stage == 5): ?>
																	<span
																		class="badge badge-danger"><?php echo app('translator')->get('Cancel'); ?></span>
																<?php endif; ?>
															</td>
															<td data-label="<?php echo app('translator')->get('Action'); ?>">
																<a href="<?php echo e(route('admin.order.view',$item->order_number)); ?>"
																   class="btn btn-outline-primary btn-sm mr-2"
																   title="<?php echo app('translator')->get('view details'); ?>"><i
																		class="fa fa-eye"></i></a>
															</td>
														</tr>
													<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
													</tbody>
												</table>
											</div>
											<div class="card-footer">
												<?php echo e($orders->links()); ?>

											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
	</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/admin/store/orderList.blade.php ENDPATH**/ ?>