<?php $__env->startSection('page_title', __('KYC Form')); ?>
<?php $__env->startSection('content'); ?>
	<div class="main-content">
		<section class="section">
			<div class="section-header">
				<h1><?php echo app('translator')->get('KYC Form'); ?></h1>
				<div class="section-header-breadcrumb">
					<div class="breadcrumb-item active">
						<a href="<?php echo e(route('admin.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
					</div>
					<div class="breadcrumb-item"><?php echo app('translator')->get('KYC Form'); ?></div>
				</div>
			</div>
			<div class="row mb-3">
				<div class="container-fluid" id="container-wrapper">
					<div class="row">
						<div class="col-lg-12">
							<form action="<?php echo e(route('kyc.update')); ?>" method="post">
								<?php echo csrf_field(); ?>
								<div class="card mb-4 card-primary shadow-sm">
									<div
										class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
										<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('KYC Form'); ?></h6>
										<div class="row">
											<label class="custom-switch mt-2" for="is_active">
												<input type="checkbox" name="is_active" id="is_active"
													   class="custom-switch-input" value="1"
													   <?php if(!empty($kyc) && $kyc->status == '1'): ?> checked <?php endif; ?>>
												<span class="custom-switch-indicator"></span>
												<span
													class="custom-switch-description"><?php echo app('translator')->get('KYC'); ?></span>
											</label>
											<a href="javascript:void(0)"
											   class="btn btn-dark btn-sm btn-rounded p-6 ml-4"
											   id="generate"><i class="fa fa-plus-circle"></i>
												<?php echo e(trans('Add Field')); ?></a>
										</div>
									</div>
									<div class="card-body">
										<div class="row addedField">
											<?php if($kyc): ?>
												<?php $__currentLoopData = $kyc->input_form; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
													<div class="col-md-12">
														<div class="form-group">
															<div class="input-group">

																<input name="field_name[]" class="form-control"
																	   type="text" value="<?php echo e($v->field_level); ?>"
																	   required
																	   placeholder="<?php echo e(trans('Field Name')); ?>">

																<select name="type[]" class="form-control  ">
																	<option value="text"
																			<?php if($v->type == 'text'): ?> selected <?php endif; ?>><?php echo e(trans('Input Text')); ?></option>
																	<option value="textarea"
																			<?php if($v->type == 'textarea'): ?> selected <?php endif; ?>><?php echo e(trans('Textarea')); ?></option>
																	<option value="file"
																			<?php if($v->type == 'file'): ?> selected <?php endif; ?>><?php echo e(trans('File upload')); ?></option>
																</select>

																<select name="validation[]" class="form-control  ">
																	<option value="required"
																			<?php if($v->validation == 'required'): ?> selected <?php endif; ?>><?php echo e(trans('Required')); ?></option>
																	<option value="nullable"
																			<?php if($v->validation == 'nullable'): ?> selected <?php endif; ?>><?php echo e(trans('Optional')); ?></option>
																</select>
																<span class="input-group-btn">
																	<button class="btn btn-danger  delete_desc"
																			type="button">
																		<i class="fa fa-times"></i>
																	</button>
																</span>
															</div>
														</div>
													</div>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
											<?php endif; ?>
										</div>
										<button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Save Changes'); ?></button>
									</div>
								</div>
							</form>
						</div>
					</div>
				</div>
			</div>
		</section>
	</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
	<script>
		'use script'
		$(document).on('click', '#generate', function () {
			console.log("lol")
			var form = `<div class="col-md-12">
                                <div class="form-group">
                                    <div class="input-group">
                                        <input name="field_name[]" class="form-control " type="text" value="" required placeholder="<?php echo e(trans('Field Name')); ?>">

                                        <select name="type[]"  class="form-control  ">
                                            <option value="text"><?php echo e(trans('Input Text')); ?></option>
                                            <option value="textarea"><?php echo e(trans('Textarea')); ?></option>
                                            <option value="file"><?php echo e(trans('File upload')); ?></option>
                                        </select>

                                        <select name="validation[]"  class="form-control  ">
                                            <option value="required"><?php echo e(trans('Required')); ?></option>
                                            <option value="nullable"><?php echo e(trans('Optional')); ?></option>
                                        </select>

                                        <span class="input-group-btn">
                                            <button class="btn btn-danger delete_desc" type="button">
                                                <i class="fa fa-times"></i>
                                            </button>
                                        </span>
                                    </div>
                                </div>
                            </div> `;

			$('.addedField').append(form)
		});

		$(document).on('click', '.delete_desc', function () {
			$(this).closest('.input-group').parent().remove();
		});

	</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/admin/kyc/create.blade.php ENDPATH**/ ?>