<?php $__env->startSection('page_title',__('Escrow List')); ?>

<?php $__env->startSection('content'); ?>
<div class="main-content">
	<section class="section">
		<div class="section-header">
			<h1><?php echo app('translator')->get('Escrow List'); ?></h1>
			<div class="section-header-breadcrumb">
				<div class="breadcrumb-item active">
					<a href="<?php echo e(route('admin.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
				</div>
				<div class="breadcrumb-item"><?php echo app('translator')->get('Escrow List'); ?></div>
			</div>
		</div>

		<div class="row mb-3">
			<div class="container-fluid" id="container-wrapper">
				<div class="row">
					<div class="col-lg-12">
						<div class="card mb-4 card-primary shadow-sm">
							<div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
								<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Search'); ?></h6>
							</div>
							<div class="card-body">
								<?php if(isset($userId)): ?>
									<form action="<?php echo e(route('admin.user.escrow.search',$userId)); ?>" method="get">
										<?php echo $__env->make('admin.escrow.searchForm', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
									</form>
								<?php else: ?>
									<form action="<?php echo e(route('admin.escrow.search')); ?>" method="get">
										<?php echo $__env->make('admin.escrow.searchForm', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
									</form>
								<?php endif; ?>
							</div>
						</div>
					</div>
				</div>
				<div class="row">
					<div class="col-lg-12">
						<div class="card mb-4 card-primary shadow">
							<div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
								<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Escrow List'); ?></h6>
							</div>
							<div class="card-body">
								<div class="table-responsive">
									<table class="table table-striped table-hover align-items-center table-borderless">
										<thead class="thead-light">
										<tr>
											<th><?php echo app('translator')->get('SL'); ?></th>
											<th><?php echo app('translator')->get('Sender'); ?></th>
											<th><?php echo app('translator')->get('Amount'); ?></th>
											<th><?php echo app('translator')->get('Receiver'); ?></th>
											<th><?php echo app('translator')->get('Receiver E-Mail'); ?></th>
											<th><?php echo app('translator')->get('Transaction ID'); ?></th>
											<th><?php echo app('translator')->get('Status'); ?></th>
											<th><?php echo app('translator')->get('Created At'); ?></th>
										</tr>
										</thead>
										<tbody>
										<?php $__empty_1 = true; $__currentLoopData = $escrows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $escrow): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
											<tr>
												<td data-label="<?php echo app('translator')->get('SL'); ?>"><?php echo e(loopIndex($escrows) + $key); ?></td>

												<td data-label="<?php echo app('translator')->get('Sender'); ?>">
													<a href="<?php echo e(route('user.edit', $escrow->sender_id)); ?>"
													   class="text-decoration-none">
														<div class="d-lg-flex d-block align-items-center ">
															<div class="mr-3"><img
																	src="<?php echo e(optional($escrow->sender)->profilePicture()??asset('assets/upload/boy.png')); ?>"
																	alt="user"
																	class="rounded-circle" width="35"
																	data-toggle="tooltip" title=""
																	data-original-title="<?php echo e(optional($escrow->sender)->name?? __('N/A')); ?>">
															</div>
															<div
																class="d-inline-flex d-lg-block align-items-center">
																<p class="text-dark mb-0 font-16 font-weight-medium"><?php echo e(Str::limit(optional($escrow->sender)->name?? __('N/A'),20)); ?></p>
																<span
																	class="text-muted font-14 ml-1"><?php echo e('@'.optional($escrow->sender)->username?? __('N/A')); ?></span>
															</div>
														</div>
													</a>

												</td>


												<td data-label="<?php echo app('translator')->get('Amount'); ?>"><?php echo e(getAmount($escrow->amount).' '.__(optional($escrow->currency)->code)); ?></td>

												<td data-label="<?php echo app('translator')->get('Receiver'); ?>">
													<a href="<?php echo e(route('user.edit', $escrow->receiver_id)); ?>"
													   class="text-decoration-none">
														<div class="d-lg-flex d-block align-items-center ">
															<div class="mr-3"><img
																	src="<?php echo e(optional($escrow->receiver)->profilePicture() ??asset('assets/upload/boy.png')); ?>"
																	alt="user"
																	class="rounded-circle" width="35"
																	data-toggle="tooltip" title=""
																	data-original-title="<?php echo e(optional($escrow->receiver)->name?? __('N/A')); ?>">
															</div>
															<div
																class="d-inline-flex d-lg-block align-items-center">
																<p class="text-dark mb-0 font-16 font-weight-medium"><?php echo e(Str::limit(optional($escrow->receiver)->name?? __('N/A'),20)); ?></p>
																<span
																	class="text-muted font-14 ml-1"><?php echo e('@'.optional($escrow->receiver)->username?? __('N/A')); ?></span>
															</div>
														</div>
													</a>
												</td>
												<td data-label="<?php echo app('translator')->get('Receiver E-Mail'); ?>"><?php echo e(__($escrow->email)); ?></td>
												<td data-label="<?php echo app('translator')->get('Transaction ID'); ?>"><?php echo e(__($escrow->utr)); ?></td>
												<td data-label="<?php echo app('translator')->get('Status'); ?>">
													<?php if($escrow->status == 1): ?>
														<span class="badge badge-info"><?php echo app('translator')->get('Generated'); ?></span>
													<?php elseif($escrow->status == 2): ?>
														<span class="badge badge-success"><?php echo app('translator')->get('Payment done'); ?></span>
													<?php elseif($escrow->status == 3): ?>
														<span class="badge badge-success"><?php echo app('translator')->get('Sender request to payment disburse'); ?></span>
													<?php elseif($escrow->status == 4): ?>
														<span class="badge badge-success"><?php echo app('translator')->get('Payment disbursed'); ?></span>
													<?php elseif($escrow->status == 5): ?>
														<span class="badge badge-success"><?php echo app('translator')->get('Canceled'); ?></span>
													<?php elseif($escrow->status == 0): ?>
														<span class="badge badge-warning"><?php echo app('translator')->get('Pending'); ?></span>
													<?php elseif($escrow->status == 6): ?>
														<span class="badge badge-warning"><?php echo app('translator')->get('Dispute'); ?></span>
														<?php if(optional($escrow->disputable)->status == 1): ?>
															<span class="badge badge-info"><?php echo app('translator')->get('Refunded'); ?></span>
														<?php elseif(optional($escrow->disputable)->status == 2): ?>
															<span class="badge badge-info"><?php echo app('translator')->get('Payment Disbursed'); ?></span>
														<?php endif; ?>
													<?php else: ?>
														<span class="badge badge-warning"><?php echo app('translator')->get('N/A'); ?></span>
													<?php endif; ?>
												</td>
												<td data-label="<?php echo app('translator')->get('Created At'); ?>"> <?php echo e(__(date('Y-m-d h:i a',strtotime($escrow->created_at)))); ?> </td>
											</tr>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
											<tr>
												<th colspan="100%" class="text-center"><?php echo app('translator')->get('No data found'); ?></th>
											</tr>
										<?php endif; ?>
										</tbody>
									</table>
								</div>
								<div class="card-footer">
									<?php echo e($escrows->links()); ?>

								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

	</section>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/admin/escrow/index.blade.php ENDPATH**/ ?>