<?php $__env->startSection('page_title', __('Currency Exchange Api Config')); ?>
<?php $__env->startPush('extra_styles'); ?>
	<link href="<?php echo e(asset('assets/dashboard/css/select2.min.css')); ?>" rel="stylesheet" type="text/css">
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
<div class="main-content">
	<section class="section">
		<div class="section-header">
			<h1><?php echo app('translator')->get('Currency Exchange Api Config'); ?></h1>
			<div class="section-header-breadcrumb">
				<div class="breadcrumb-item active">
					<a href="<?php echo e(route('admin.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
				</div>
				<div class="breadcrumb-item"><?php echo app('translator')->get('Currency Exchange Api Config'); ?></div>
			</div>
		</div>

		<div class="section-body">
			<div class="row mt-sm-4">
				<div class="col-12 col-md-4 col-lg-3">
					<?php echo $__env->make('admin.control_panel.components.sidebar', ['settings' => config('generalsettings.settings'), 'suffix' => 'Settings'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
				</div>
				<div class="col-12 col-md-8 col-lg-9">
					<div class="container-fluid" id="container-wrapper">
						<div class="row justify-content-center">
							<div class="col-lg-7">
								<div class="card card-primary shadow mb-4">
									<form action="<?php echo e(route('currency.exchange.api.config')); ?>" method="post">
										<?php echo csrf_field(); ?>
										<div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
											<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('CurrencyLayer Api Config (Fiat Currency)'); ?></h6>
										</div>
										<div class="card-body">
											<div class="row">
												<div class="col-md-12">
													<div class="form-group">
														<label for="currency_layer_access_key"><?php echo app('translator')->get('Currency Layer Access Key'); ?></label>
														<input type="text" name="currency_layer_access_key" value="<?php echo e(old('currency_layer_access_key',$basicControl->currency_layer_access_key)); ?>"
															   placeholder="<?php echo app('translator')->get('Enter your currency layer access key'); ?>"
															   class="form-control <?php $__errorArgs = ['currency_layer_access_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
														<div class="invalid-feedback">
															<?php $__errorArgs = ['currency_layer_access_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
														</div>
													</div>
												</div>
												<div class="col-md-12">
													<div class="form-group">
														<label for="currency_layer_auto_update_at"><?php echo app('translator')->get('Select Update Time'); ?></label>
														<select name="currency_layer_auto_update_at" class="select2-single form-control form-control-sm">
															<?php $__currentLoopData = config('basic.schedule_list'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
																<option value="<?php echo e($key); ?>" <?php echo e($key == old('currency_layer_auto_update_at',$basicControl->currency_layer_auto_update_at) ? 'selected' : ''); ?>> <?php echo app('translator')->get($value); ?></option>
															<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
														</select>
													</div>
												</div>
												<div class="col-md-6">
													<div class="form-group">
														<label><?php echo app('translator')->get('Auto Update Currency Rate'); ?></label>
														<div class="selectgroup w-100">
															<label class="selectgroup-item">
																<input type="radio" name="currency_layer_auto_update" value="0"
																		 class="selectgroup-input" <?php echo e(old('currency_layer_auto_update', $basicControl->currency_layer_auto_update) == 0 ? 'checked' : ''); ?>>
																<span class="selectgroup-button"><?php echo app('translator')->get('OFF'); ?></span>
															</label>
															<label class="selectgroup-item">
																<input type="radio" name="currency_layer_auto_update" value="1"
																		 class="selectgroup-input" <?php echo e(old('currency_layer_auto_update', $basicControl->currency_layer_auto_update) == 1 ? 'checked' : ''); ?>>
																<span class="selectgroup-button"><?php echo app('translator')->get('ON'); ?></span>
															</label>
														</div>
														<?php $__errorArgs = ['currency_layer_auto_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
															<span class="text-danger" role="alert">
																<strong><?php echo e(__($message)); ?></strong>
															</span>
														<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
													</div>
												</div>
											</div>
										</div>
										<div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
											<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('CoinMarketCap Api Config (Crypto Currency)'); ?></h6>
										</div>
										<div class="card-body">
											<div class="row">
												<div class="col-md-12">
													<div class="form-group">
														<label for="coin_market_cap_app_key"><?php echo app('translator')->get('Coin Market Cap App Key'); ?></label>
														<input type="text" name="coin_market_cap_app_key" value="<?php echo e(old('coin_market_cap_app_key',$basicControl->coin_market_cap_app_key)); ?>"
															   placeholder="<?php echo app('translator')->get('Enter your coin market cap app key'); ?>"
															   class="form-control <?php $__errorArgs = ['coin_market_cap_app_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
														<div class="invalid-feedback">
															<?php $__errorArgs = ['coin_market_cap_app_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
														</div>
													</div>
												</div>
												<div class="col-md-12">
													<div class="form-group">
														<label for="coin_market_cap_auto_update_at"><?php echo app('translator')->get('Select Update Time'); ?></label>
														<select name="coin_market_cap_auto_update_at" class="select2-single form-control form-control-sm">
															<?php $__currentLoopData = config('basic.schedule_list'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
																<option value="<?php echo e($key); ?>" <?php echo e($key == old('coin_market_cap_auto_update_at',$basicControl->coin_market_cap_auto_update_at) ? 'selected' : ''); ?>> <?php echo app('translator')->get($value); ?></option>
															<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
														</select>
													</div>
												</div>
												<div class="col-md-6">
													<div class="form-group">
														<label><?php echo app('translator')->get('Auto Update Currency Rate'); ?></label>
														<div class="selectgroup w-100">
															<label class="selectgroup-item">
																<input type="radio" name="coin_market_cap_auto_update" value="0"
																		 class="selectgroup-input" <?php echo e(old('coin_market_cap_auto_update', $basicControl->coin_market_cap_auto_update) == 0 ? 'checked' : ''); ?>>
																<span class="selectgroup-button"><?php echo app('translator')->get('OFF'); ?></span>
															</label>
															<label class="selectgroup-item">
																<input type="radio" name="coin_market_cap_auto_update" value="1"
																		 class="selectgroup-input" <?php echo e(old('coin_market_cap_auto_update', $basicControl->coin_market_cap_auto_update) == 1 ? 'checked' : ''); ?>>
																<span class="selectgroup-button"><?php echo app('translator')->get('ON'); ?></span>
															</label>
														</div>
														<?php $__errorArgs = ['coin_market_cap_auto_update'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
															<span class="text-danger" role="alert">
																<strong><?php echo e(__($message)); ?></strong>
															</span>
														<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
													</div>
												</div>
											</div>
										</div>
										<div class="card-footer">
											<button type="submit" class="btn btn-block btn-primary"><?php echo app('translator')->get('Save Changes'); ?></button>
										</div>
									</form>
								</div>
							</div>
							<div class="col-lg-5">
								<div class="row">
									<div class="col-12">
										<div class="card card-primary shadow mb-4">
											<div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
												<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Currency Layer Instructions'); ?></h6>
											</div>
											<div class="card-body">
												<?php echo app('translator')->get('Currencylayer provides a simple REST API with real-time and historical exchange rates for 168 world currencies,
												delivering currency pairs in universally usable JSON format - compatible with any of your applications.
												<br><br>
												Spot exchange rate data is retrieved from several major forex data providers in real-time, validated,
												processed and delivered hourly, Every 10 minutes, or even within the 60-second market window.'); ?>
												<a href="https://currencylayer.com/product" target="_blank"><?php echo app('translator')->get('Create an account'); ?> <i class="fas fa-external-link-alt"></i></a>
											</div>
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-12">
										<div class="card card-primary shadow mb-4">
											<div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
												<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Coin Market Cap Instructions'); ?></h6>
											</div>
											<div class="card-body">
												<?php echo app('translator')->get('CoinMarketCap is the world\'s most-referenced price-tracking website for cryptoassets in the rapidly growing cryptocurrency space.
												Its mission is to make crypto discoverable and efficient globally by empowering retail users with unbiased,
												high quality and accurate information for drawing their own informed conclusions.
												Get your free API keys'); ?>
												<a href="https://dashboard.pusher.com/accounts/sign_up" target="_blank"><?php echo app('translator')->get('Create an account'); ?> <i class="fas fa-external-link-alt"></i></a>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('extra_scripts'); ?>
	<script src="<?php echo e(asset('assets/dashboard/js/select2.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('scripts'); ?>
	<script>
		'use strict'
		$(document).ready(function () {
			$('.select2-single').select2();
			$(document).on('click', '.copy-btn', function () {
				let _this = $(this)[0];
				let copyText = $(this).parents('.input-group-append').siblings('input');
				$(copyText).prop('disabled', false);
				copyText.select();
				document.execCommand("copy");
				$(copyText).prop('disabled', true);
				$(this).text('Coppied');
				setTimeout(function () {
					$(_this).text('');
					$(_this).html('<i class="fas fa-copy"></i>');
				}, 500)
			});
		});
	</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/admin/control_panel/currencyExchangeApiConfig.blade.php ENDPATH**/ ?>