<?php $__env->startSection('page_title',__('Pay Bill')); ?>
<?php $__env->startSection('content'); ?>
	<div class="main-content">
		<section class="section">
			<div class="section-header">
				<h1><?php echo app('translator')->get('Pay Bill'); ?></h1>
				<div class="section-header-breadcrumb">
					<div class="breadcrumb-item active">
						<a href="<?php echo e(route('user.dashboard')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
					</div>
					<div class="breadcrumb-item"><?php echo app('translator')->get('Pay Bill'); ?></div>
				</div>
			</div>
			<!------ alert ------>
			<div class="row mb-3">
				<div class="container-fluid" id="container-wrapper">
					<div class="row justify-content-md-center">
						<div class="col-md-6">
							<div class="card mb-4 card-primary shadow">
								<div
									class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
									<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Pay Bill'); ?></h6>
								</div>
								<div class="card-body payout">
									<form action="<?php echo e(route('pay.bill.submit')); ?>" method="post">
										<?php echo csrf_field(); ?>
										<div class="row">
											<div class="col-md-12">
												<div class="bill-categories">
													<div class="row g-4">
														<div class="col-xl-2 col-lg-3 col-md-4 col-6">
														   <span class="tag-item">
															  <input type="radio" value="airtime" class="btn-check"
																	 name="category"
																	 id="bill1" autocomplete="off" checked/>
															  <label class="btn btn-primary" for="bill1">
																 <img
																	 src="<?php echo e(asset('assets/frontend/images/airplane.png')); ?>"
																	 alt="<?php echo app('translator')->get('AirTime'); ?>"/>
																 <p><?php echo app('translator')->get('AirTime'); ?></p>
															  </label>
														   </span>
														</div>
														<div class="col-xl-2 col-lg-3 col-md-4 col-6">
														   <span class="tag-item">
															  <input type="radio" value="power" class="btn-check"
																	 name="category"
																	 id="bill2" autocomplete="off"/>
															  <label class="btn btn-primary" for="bill2">
																 <img
																	 src="<?php echo e(asset('assets/frontend/images/electricity.png')); ?>"
																	 alt="<?php echo app('translator')->get('Electricity'); ?>"/>
																 <p><?php echo app('translator')->get('Electricity'); ?></p>
															  </label>
														   </span>
														</div>
														<div class="col-xl-2 col-lg-3 col-md-4 col-6">
														   <span class="tag-item">
															  <input type="radio" value="internet" class="btn-check"
																	 name="category"
																	 id="bill3" autocomplete="off"/>
															  <label class="btn btn-primary" for="bill3">
																 <img
																	 src="<?php echo e(asset('assets/frontend/images/internet.png')); ?>"
																	 alt="<?php echo app('translator')->get('Internet'); ?>"/>
																 <p><?php echo app('translator')->get('Internet'); ?></p>
															  </label>
														   </span>
														</div>
														<div class="col-xl-2 col-lg-3 col-md-4 col-6">
														   <span class="tag-item">
															  <input type="radio" value="toll" class="btn-check"
																	 name="category"
																	 id="bill4" autocomplete="off"/>
															  <label class="btn btn-primary" for="bill4">
																 <img
																	 src="<?php echo e(asset('assets/frontend/images/toll.png')); ?>"
																	 alt="<?php echo app('translator')->get('Toll'); ?>"/>
																 <p><?php echo app('translator')->get('Toll'); ?></p>
															  </label>
														   </span>
														</div>
														<div class="col-xl-2 col-lg-3 col-md-4 col-6">
														   <span class="tag-item">
															  <input type="radio" value="cables" class="btn-check"
																	 name="category"
																	 id="bill5" autocomplete="off"/>
															  <label class="btn btn-primary" for="bill5">
																 <img
																	 src="<?php echo e(asset('assets/frontend/images/smart-tv.png')); ?>"
																	 alt="<?php echo app('translator')->get('Cable Tv'); ?>"/>
																 <p><?php echo app('translator')->get('Cable Tv'); ?></p>
															  </label>
														   </span>
														</div>
														<div class="col-xl-2 col-lg-3 col-md-4 col-6">
														   <span class="tag-item">
															  <input type="radio" value="data_bundle" class="btn-check"
																	 name="category"
																	 id="bill6" autocomplete="off"/>
															  <label class="btn btn-primary" for="bill6">
																 <img
																	 src="<?php echo e(asset('assets/frontend/images/data-bundle.png')); ?>"
																	 alt="<?php echo app('translator')->get('Data Bundle'); ?>"/>
																 <p><?php echo app('translator')->get('Data Bundle'); ?></p>
															  </label>
														   </span>
														</div>
													</div>
												</div>
											</div>
										</div>
										<div class="row">
											<div class="col-md-12">
												<div class="form-group search-currency-dropdown">
													<label for="from_wallet"><?php echo app('translator')->get('From Wallet'); ?></label>
													<select id="from_wallet" name="from_wallet"
															class="form-control form-control-sm">
														<option value="" disabled
																selected><?php echo app('translator')->get('Select wallet'); ?></option>
														<?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
															<option value="<?php echo e($currency->id); ?>">
																<?php echo e(__($currency->code)); ?>

																- <?php echo e(__($currency->name)); ?> </option>
														<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
													</select>
												</div>
											</div>
										</div>
										<div class="row">
											<div class="col-md-12">
												<lable><?php echo app('translator')->get('Country'); ?></lable>
												<select class="form-select form-control mt-1 country" name="country"
														data-resource="<?php echo e(json_encode($countryLists)); ?>" required>
													<option value="" selected=""
															disabled><?php echo app('translator')->get('Select Country'); ?></option>
													<?php if($countryNames): ?>
														<?php $__currentLoopData = $countryNames; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
															<option value="<?php echo e($key); ?>"><?php echo e($name); ?></option>
														<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
													<?php endif; ?>
												</select>
												<?php $__errorArgs = ['country'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
												<span class="text-danger"><?php echo e($message); ?></span>
												<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div>
										</div>
										<div class="row dynamic-services mx-1 mt-4">
											<label><?php echo app('translator')->get('Services'); ?></label>
											<select id="dynamic-services" name="service"
													class="form-control form-control-sm" required>
											</select>
											<?php $__errorArgs = ['service'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
											<span class="text-danger"><?php echo e($message); ?></span>
											<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
										</div>

										<div class="row mt-4">
											<div class="col-md-12">
												<div class="form-group">
													<div id="showLabel">
														<label for="amount"><?php echo app('translator')->get('Customer'); ?></label>
													</div>
													<input type="text" name="customer" value="<?php echo e(old('customer')); ?>"
														   class="form-control <?php $__errorArgs = ['customer'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
														   required>
													<div
														class="invalid-feedback"><?php $__errorArgs = ['customer'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?></div>
												</div>
											</div>
										</div>

										<div class="row">
											<div class="col-md-12">
												<div class="form-group">
													<label for="amount"><?php echo app('translator')->get('Amount'); ?></label>
													<div class="input-group input-group-sm">
														<input type="text" name="amount" value="<?php echo e(old('amount')); ?>"
															   placeholder="<?php echo app('translator')->get('Enter Amount'); ?>"
															   class="form-control amount <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
															   required>
														<div class="input-group-prepend">
															<span
																class="input-group-text showCurrency"></span>
														</div>
													</div>
													<div
														class="invalid-feedback"><?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?></div>
												</div>
											</div>
										</div>
										<button type="submit" id="submit"
												class="btn btn-primary btn-sm btn-block"><?php echo app('translator')->get('Continue'); ?></button>
									</form>
								</div>
							</div>
						</div>
						<div class="col-md-6">
							<div class="card mb-4 card-primary shadow">
								<div
									class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
									<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Details'); ?></h6>
								</div>
								<div class="card-body showCharge d-none">
									<ul class="list-group">
										<li class="list-group-item d-flex justify-content-between align-items-center">
											<span><?php echo app('translator')->get('Fixed charge'); ?></span>
											<span class="text-danger" id="fixed_charge"></span>
										</li>
										<li class="list-group-item d-flex justify-content-between align-items-center">
											<span><?php echo app('translator')->get('Percentage charge'); ?></span><span class="text-danger"
																						 id="percentage_charge"></span>
										</li>
										<li class="list-group-item d-flex justify-content-between align-items-center">
											<span><?php echo app('translator')->get('Min limit'); ?></span>
											<span class="text-info" id="min_limit"></span>
										</li>
										<li class="list-group-item d-flex justify-content-between align-items-center">
											<span><?php echo app('translator')->get('Max limit'); ?></span>
											<span class="text-info" id="max_limit"></span>
										</li>
									</ul>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
	</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
	<script>
		'use strict';
		$(document).on('change', '.country', function () {
			var country = $(this).data('resource');
			var code = $(this).find(':selected').val()
			var category = $("input[name='category']:checked").val();
			currencCode(country, code);
			fetchService(category, code);

		})

		$(document).on('click', "input[name='category']", function () {
			var country = $('.country').data('resource');
			var code = $('.country').find(':selected').val()
			var category = $("input[name='category']:checked").val();
			currencCode(country, code);
			fetchService(category, code);
			removeAttr();
		})

		$(document).on('change', '#dynamic-services', function () {
			$('.showCharge').addClass('d-none');
			removeAttr();

			let fixed = $(this).find(':selected').data('fixed')
			let percent = $(this).find(':selected').data('percent')
			let min = $(this).find(':selected').data('min')
			let max = $(this).find(':selected').data('max')
			let currency = $(this).find(':selected').data('currency')
			let amount = $(this).find(':selected').data('amount')
			let label = $(this).find(':selected').data('label')

			$('#showLabel').html('')
			$('#showLabel').append(`<label for="${label}">${label}</label>`)

			if (currency) {
				$('.showCharge').removeClass('d-none');
			}
			$('#fixed_charge').text(`${fixed} ${currency}`);
			$('#percentage_charge').text(`${percent}%`);
			$('#min_limit').text(`${min} ${currency}`);
			$('#max_limit').text(`${max} ${currency}`);

			if (amount > 0) {
				$('.amount').val(amount).attr('readonly', true);
			}
		})

		function removeAttr() {
			$('.amount').val('').attr('readonly', false);
		}

		function currencCode(country, code) {
			Object.keys(country).forEach(key => {
				let singleCode = country[key].code;
				if (singleCode == code) {
					$('.showCurrency').text(country[key].iso_code)
					return;
				}
			});
		}

		function fetchService(category, code) {
			$.ajax({
				headers: {'X-CSRF-TOKEN': $('meta[name="csrf_token"]').attr('content')},
				url: "<?php echo e(route('fetch.services')); ?>",
				data: {category: category, code: code},
				dataType: 'json',
				type: "post",
				success: function (data) {
					if (data.status == 'success') {
						let services = data.data;
						showServices(services);
					}
				}
			});
		}

		function showServices(services) {
			$('#dynamic-services').html('');
			var options = `<option disabled value="" selected><?php echo app('translator')->get("Select Service"); ?></option>`;
			for (let i = 0; i < services.length; i++) {
				options += `<option value="${services[i].id}" data-percent="${services[i].percent_charge}"
                data-fixed="${services[i].fixed_charge}" data-min="${services[i].min_amount}" data-max="${services[i].max_amount}"
                data-currency="${services[i].currency}" data-amount="${services[i].amount}" data-label="${services[i].label_name}">${services[i].type}</option>`;
			}
			$('#dynamic-services').html(options);
		}

	</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/user/bill_pay/request.blade.php ENDPATH**/ ?>