<?php $__env->startSection('page_title',__('Track Order')); ?>

<?php $__env->startSection('content'); ?>
	<div class="track-order">
		<div class="container">
			<form action="<?php echo e(route('public.product.track',$link)); ?>" method="get">
				<div class="row g-4 justify-content-center">
					<div class="input-box input-group col-lg-6">
						<input class="form-control" type="text" name="orderNumber" value="<?php echo e(@request()->orderNumber); ?>"
							   placeholder="<?php echo app('translator')->get('Order Number'); ?>"/>
						<button class="btn-custom"><?php echo app('translator')->get('Track Order'); ?></button>
					</div>
				</div>
			</form>
			<div class="row">
				<?php if($order->stage != 5 ): ?>
					<div class="col">
						<div class="process">
							<div class="box">
								<div class="icon <?php echo e(isStageDone('0',$order->stage)); ?>">
									<img src="<?php echo e(asset('assets/store/img/icon/process-1.png')); ?>" alt="..."/>
								</div>
								<h5><?php echo app('translator')->get('Accepted'); ?></h5>
							</div>
							<div class="box">
								<div class="icon <?php echo e(isStageDone('1',$order->stage)); ?>">
									<img src="<?php echo e(asset('assets/store/img/icon/process-2.png')); ?>" alt="..."/>
								</div>
								<h5><?php echo app('translator')->get('Picked'); ?></h5>
							</div>
							<div class="box">
								<div class="icon <?php echo e(isStageDone('2',$order->stage)); ?>">
									<img src="<?php echo e(asset('assets/store/img/icon/process-3.png')); ?>" alt="..."/>
								</div>
								<h5><?php echo app('translator')->get('In Transit'); ?></h5>
							</div>
							<div class="box">
								<div class="icon <?php echo e(isStageDone('3',$order->stage)); ?>">
									<img src="<?php echo e(asset('assets/store/img/icon/process-4.png')); ?>" alt="..."/>
								</div>
								<h5><?php echo app('translator')->get('Out for delivery'); ?></h5>
							</div>
							<div class="box">
								<div class="icon <?php echo e(isStageDone('4',$order->stage)); ?>">
									<img src="<?php echo e(asset('assets/store/img/icon/process-5.png')); ?>" alt="..."/>
								</div>
								<h5><?php echo app('translator')->get('Delivered'); ?></h5>
							</div>
						</div>
					</div>
				<?php else: ?>
					<div class="col">
						<div class="process">
							<div class="box">
								<div class="icon completed">
									<img src="<?php echo e(asset('assets/store/img/icon/process-1.png')); ?>" alt="..."/>
								</div>
								<h5><?php echo app('translator')->get('Accepted'); ?></h5>
							</div>
							<div class="box">
								<div class="icon <?php echo e(cancelFrom(1,$order->cancel_from)); ?>">
									<img src="<?php echo e(asset('assets/store/img/icon/process-2.png')); ?>" alt="..."/>
								</div>
								<h5><?php echo app('translator')->get('Picked'); ?></h5>
							</div>
							<div class="box">
								<div class="icon <?php echo e(cancelFrom(2,$order->cancel_from)); ?>">
									<img src="<?php echo e(asset('assets/store/img/icon/process-3.png')); ?>" alt="..."/>
								</div>
								<h5><?php echo app('translator')->get('In Transit'); ?></h5>
							</div>
							<div class="box">
								<div class="icon <?php echo e(cancelFrom(3,$order->cancel_from)); ?>">
									<img src="<?php echo e(asset('assets/store/img/icon/process-4.png')); ?>" alt="..."/>
								</div>
								<h5><?php echo app('translator')->get('Out for delivery'); ?></h5>
							</div>
							<div class="box">
								<div class="icon <?php echo e(cancelFrom(4,$order->cancel_from)); ?>">
									<img src="<?php echo e(asset('assets/store/img/icon/process-5.png')); ?>" alt="..."/>
								</div>
								<h5><?php echo app('translator')->get('Delivered'); ?></h5>
							</div>
							<div class="box">
								<div class="icon cancel">
									<img src="<?php echo e(asset('assets/store/img/icon/cancel.png')); ?>" alt="..."/>
								</div>
								<h5><?php echo app('translator')->get('Cancel'); ?></h5>
							</div>
						</div>
					</div>
				<?php endif; ?>
			</div>
			<?php if($order->stage != -1): ?>
				<div class="row justify-content-center">
					<div class="col-lg-6">
						<div class="order-status">
							<div class="d-md-flex justify-content-between">
								<div>
									<h5><?php echo app('translator')->get('Order:'); ?> <span>#<?php echo e($order->order_number); ?></span></h5>
									<p><?php echo app('translator')->get('Place Order:'); ?> <?php echo e(dateTime($order->created_at)); ?></p>
								</div>
								<div>
									<h5><?php echo app('translator')->get('Delivery To:'); ?></h5>
									<p><?php echo e($order->detailed_address); ?></p>
								</div>
							</div>
							<a class="print-invoice" target="_blank"
							   href="<?php echo e(route('public.product.orderDownload',$order->id)); ?>">
								<i class="fal fa-file-invoice"></i> <?php echo app('translator')->get('Print Order'); ?>
							</a>
						</div>
					</div>
				</div>
			<?php endif; ?>
		</div>
	</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.storeMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/user/store/orderTrack.blade.php ENDPATH**/ ?>