<?php $__env->startSection('page_title',__('Pay Bill List')); ?>

<?php $__env->startSection('content'); ?>
	<div class="main-content">
		<section class="section">
			<div class="section-header">
				<h1><?php echo app('translator')->get('Pay Bill List'); ?></h1>
				<div class="section-header-breadcrumb">
					<div class="breadcrumb-item active">
						<a href="<?php echo e(route('user.dashboard')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
					</div>
					<div class="breadcrumb-item"><?php echo app('translator')->get('Pay Bill List'); ?></div>
				</div>
			</div>

			<div class="row mb-3">
				<div class="container-fluid" id="container-wrapper">
					<div class="row">
						<div class="col-lg-12">
							<div class="card mb-4 card-primary shadow-sm">
								<div
									class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
									<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Search'); ?></h6>
								</div>
								<div class="card-body">
									<form action="<?php echo e(route('pay.bill.list')); ?>" method="get">
										<?php echo $__env->make('user.bill_pay.searchForm', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
									</form>
								</div>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-lg-12">
							<div class="card mb-4 card-primary shadow">
								<div
									class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
									<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Pay Bill List'); ?></h6>
								</div>
								<div class="card-body">
									<div class="table-responsive">
										<table
											class="table table-striped table-hover align-items-center table-borderless">
											<thead class="thead-light">
											<tr>
												<th><?php echo app('translator')->get('SL'); ?></th>
												<th><?php echo app('translator')->get('Category'); ?></th>
												<th><?php echo app('translator')->get('Type'); ?></th>
												<th><?php echo app('translator')->get('Amount'); ?></th>
												<th><?php echo app('translator')->get('Charge'); ?></th>
												<th><?php echo app('translator')->get('Status'); ?></th>
												<th><?php echo app('translator')->get('Created time'); ?></th>
												<th><?php echo app('translator')->get('Action'); ?></th>
											</tr>
											</thead>
											<tbody>
											<?php $__empty_1 = true; $__currentLoopData = $bills; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
												<tr>
													<td data-label="<?php echo app('translator')->get('SL'); ?>"><?php echo e(loopIndex($bills) + $key); ?></td>
													<td data-label="<?php echo app('translator')->get('Category'); ?>"><?php echo e(__(str_replace('_',' ',ucfirst($value->category_name)))); ?></td>
													<td data-label="<?php echo app('translator')->get('Type'); ?>"><?php echo e(__($value->type)); ?></td>
													<td data-label="<?php echo app('translator')->get('Amount'); ?>"><?php echo e((getAmount($value->amount,2)).' '.__($value->currency)); ?></td>
													<td data-label="<?php echo app('translator')->get('Charge'); ?>"><span
															class="text-danger"><?php echo e((getAmount($value->charge,2)).' '.__($value->currency)); ?></span>
													</td>
													<td data-label="<?php echo app('translator')->get('Status'); ?>">
														<?php if($value->status == 0): ?>
															<span class="badge badge-warning"><?php echo app('translator')->get('Generated'); ?></span>
														<?php elseif($value->status == 1): ?>
															<span class="badge badge-info"><?php echo app('translator')->get('Pending'); ?></span>
														<?php elseif($value->status == 2): ?>
															<span
																class="badge badge-info"><?php echo app('translator')->get('Payment Done'); ?></span>
														<?php elseif($value->status == 3): ?>
															<span class="badge badge-success"><?php echo app('translator')->get('Completed'); ?></span>
														<?php elseif($value->status == 4): ?>
															<span class="badge badge-danger"><?php echo app('translator')->get('Return'); ?></span>
														<?php endif; ?>
													</td>
													<td data-label="<?php echo app('translator')->get('Created time'); ?>"> <?php echo e(dateTime($value->created_at)); ?> </td>
													<td data-label="<?php echo app('translator')->get('Action'); ?>">
														<?php if($value->status == 0): ?>
															<a href="<?php echo e(route('pay.bill.confirm',$value->utr)); ?>"
															   target="_blank"
															   class="btn btn-sm btn-primary"><?php echo app('translator')->get('Confirm'); ?></a>
														<?php endif; ?>
													</td>
												</tr>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
												<tr>
													<th colspan="100%" class="text-center"><?php echo app('translator')->get('No data found'); ?></th>
												</tr>
											<?php endif; ?>
											</tbody>
										</table>
									</div>
									<div class="card-footer">
										<?php echo e($bills->links()); ?>

									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

		</section>
	</div>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/user/bill_pay/index.blade.php ENDPATH**/ ?>