<?php $__env->startSection('page_title', __('Add Gateway Charge')); ?>
<?php $__env->startSection('content'); ?>
<div class="main-content">
	<section class="section">
		<div class="section-header">
			<h1><?php echo app('translator')->get('Edit Charges & Limit'); ?></h1>
			<div class="section-header-breadcrumb">
				<div class="breadcrumb-item active">
					<a href="<?php echo e(route('admin.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
				</div>
				<div class="breadcrumb-item"><a href="<?php echo e(route('currency.index')); ?>"><?php echo app('translator')->get('Currency'); ?></a></div>
				<div class="breadcrumb-item"><?php echo app('translator')->get('Payment Methods Charge'); ?></div>
			</div>
		</div>

		<div class="section-body">
			<div class="container-fluid" id="container-wrapper">
				<div class="row justify-content-md-center">
					<div class="col-lg-8">
						<div class="card mb-4">
							<div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
								<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Edit Charges & Limit For '); ?> <?php echo e(__($currency->code)); ?></h6>
								<a href="<?php echo e(route('currency.index')); ?>" class="btn btn-sm btn-outline-primary"> <i
											class="fas fa-arrow-left"></i> <?php echo app('translator')->get('Back'); ?></a>
							</div>
							<div class="card-body" id="depositMethodArea">
								<div class="row">
									<div class="col-xl-3 col-lg-4">
										<div class="tabScroll">
											<div class="nav flex-column nav-pills" id="v-pills-tab" role="tablist"
												 aria-orientation="vertical">
												<?php $__currentLoopData = $methods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
													<a class="nav-link media <?php echo e($key == 0 ? 'active' : ''); ?>" data-toggle="pill"
													   href=".payment-method-form" role="tab"
													   @click.prevent="getCharge(<?php echo e($currency->id); ?>, <?php echo e($method->id); ?>)"
													   aria-selected="<?php echo e($key == 0 ? 'true' : ''); ?>">
														<span class="tabImage">
															<img src="<?php echo e(asset('assets/upload/gateway/'.$method->image)); ?>" alt="<?php echo app('translator')->get('Image'); ?>">
														</span><?php echo e(__($method->name)); ?>

													</a>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
											</div>
										</div>
									</div>
									<div class="col-xl-9 col-lg-8">
										<div class="tab-content" id="v-pills-tabContent">
											<div class="tab-pane fade show active payment-method-form" role="tabpanel">
												<form action="#" method="post" @submit.prevent="updateCharge()">
													<?php echo csrf_field(); ?>
													<div class="row">
														<div class="col-md-6">
															<div class="form-group">
																<label for="convention_rate"><?php echo app('translator')->get('Convention Rate'); ?></label>
																<div class="input-group input-group-sm">
																	<div class="input-group-prepend">
																		<span class="input-group-text"><?php echo app('translator')->get('1 '); ?> <?php echo e(__($currency->code)); ?> <?php echo app('translator')->get(' ='); ?></span>
																	</div>
																	<input type="text" placeholder="<?php echo app('translator')->get('eg:- 0.00'); ?>"
																		   v-model="items.convention_rate"
																		   class="form-control"
																		   :class="{'is-invalid' : hasErrors.convention_rate.length}">
																	<div class="input-group-append" v-cloak>
																		<span class="input-group-text">{{ items.method_currency }}</span>
																	</div>
																	<div :class="{'invalid-feedback' : hasErrors.convention_rate.length}">
																		{{ hasErrors.convention_rate }}
																	</div>
																</div>
															</div>
														</div>
														<div class="col-md-6">
															<div class="form-group">
																<label for="min_limit"><?php echo app('translator')->get('Minimum Deposit Limit'); ?></label>
																<div class="input-group input-group-sm">
																	<input type="text" placeholder="<?php echo app('translator')->get('eg:- 0.00'); ?>"
																		   v-model="items.min_limit"
																		   class="form-control"
																		   :class="{'is-invalid' : hasErrors.min_limit.length}">
																	<div class="input-group-append">
																		<span class="input-group-text"><?php echo e(__($currency->code)); ?></span>
																	</div>
																	<div :class="{'invalid-feedback' : hasErrors.min_limit.length}">
																		{{ hasErrors.min_limit }}
																	</div>
																</div>
															</div>
														</div>
														<div class="col-md-6">
															<div class="form-group">
																<label for="max_limit"><?php echo app('translator')->get('Maximum Deposit Limit'); ?></label>
																<div class="input-group input-group-sm">
																	<input type="text" placeholder="<?php echo app('translator')->get('eg:- 0.00'); ?>"
																		   v-model="items.max_limit"
																		   class="form-control"
																		   :class="{'is-invalid' : hasErrors.max_limit.length}">
																	<div class="input-group-append">
																		<span class="input-group-text"><?php echo e(__($currency->code)); ?></span>
																	</div>
																	<div :class="{'invalid-feedback' : hasErrors.max_limit.length}">
																		{{ hasErrors.max_limit }}
																	</div>
																</div>
															</div>
														</div>
														<div class="col-md-6">
															<div class="form-group">
																<label for="percentage_charge"><?php echo app('translator')->get('Percentage Charge'); ?></label>
																<div class="input-group input-group-sm">
																	<input type="text" placeholder="<?php echo app('translator')->get('eg:- 0.00'); ?>"
																		   v-model="items.percentage_charge"
																		   class="form-control"
																		   :class="{'is-invalid' : hasErrors.percentage_charge.length}">
																	<div class="input-group-append">
																		<span class="input-group-text"><?php echo app('translator')->get('%'); ?></span></div>
																	<div :class="{'invalid-feedback' : hasErrors.percentage_charge.length}">
																		{{ hasErrors.percentage_charge }}
																	</div>
																</div>
															</div>
														</div>
														<div class="col-md-6">
															<div class="form-group">
																<label for="fixed_charge"><?php echo app('translator')->get('Fixed Charge'); ?></label>
																<div class="input-group input-group-sm">
																	<input type="text" placeholder="<?php echo app('translator')->get('eg:- 0.00'); ?>"
																		   v-model="items.fixed_charge"
																		   class="form-control"
																		   :class="{'is-invalid' : hasErrors.fixed_charge.length}">
																	<div class="input-group-append">
																		<span class="input-group-text"><?php echo e(__($currency->code)); ?></span>
																	</div>
																	<div :class="{'invalid-feedback' : hasErrors.fixed_charge.length}">
																		{{ hasErrors.fixed_charge }}
																	</div>
																</div>
															</div>
														</div>
														<div class="col-md-6">
															<div class="form-group">
																<label for="status"><?php echo app('translator')->get('Status'); ?></label>
																<div class="input-group input-group-sm ml-4">
																	<input type="checkbox" class="custom-control-input"
																		   :class="{'is-invalid' : hasErrors.is_active.length}"
																		   id="is_active"
																		   v-model="items.is_active"
																		   :checked="items.is_active == 1">
																	<label class="custom-control-label"
																		   for="is_active"><?php echo app('translator')->get('Enable Charge'); ?></label>
																	<div :class="{'invalid-feedback' : hasErrors.is_active.length}">
																		{{ hasErrors.is_active }}
																	</div>
																</div>
															</div>
														</div>
														<div class="col-md-12">
															<div class="form-group">
																<button type="submit"
																		class="btn btn-primary btn-sm btn-block"><?php echo app('translator')->get('Save Changes'); ?></button>
															</div>
														</div>
													</div>
												</form>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

	</section>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        'use strict'
        let depositMethodArea = new Vue({
            el: "#depositMethodArea",
            data: {
                items: [],
                hasErrors: {
                    'convention_rate': '',
                    'max_limit': '',
                    'min_limit': '',
                    'percentage_charge': '',
                    'fixed_charge': '',
                    'is_active': ''
                },
            },
            beforeMount() {
                this.getCharge("<?php echo e(@$currency->id); ?>", "<?php echo e(@$methods[0]->id); ?>");
            },
            methods: {
                getCharge(currency_id, payment_method_id) {
                    let app = this;
                    let url = "<?php echo e(route('get.deposit.charge',['currency_id','payment_method_id'])); ?>";
                    url = url.replace('currency_id', currency_id);
                    url = url.replace('payment_method_id', payment_method_id);
                    this.setErrorBlank()
                    axios.get(url)
                        .then(function (res) {
                            app.items = res.data;
                        })
                },
                updateCharge() {
                    let app = this;
                    let input = this.items;
                    this.setErrorBlank()
                    axios.post("<?php echo e(route('set.deposit.charge')); ?>", input)
                        .then(function (response) {
                            Notiflix.Notify.Success(response.data.message);
                        })
                        .catch(function (errors) {
                            let getError = errors.response.data[0];
                            for (var error in getError) {
                                app.hasErrors[error] = getError[error][0];
                            }
                        });

                },
                setErrorBlank() {
                    this.hasErrors.convention_rate = '';
                    this.hasErrors.max_limit = '';
                    this.hasErrors.min_limit = '';
                    this.hasErrors.percentage_charge = '';
                    this.hasErrors.fixed_charge = '';
                    this.hasErrors.is_active = '';
                }
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/admin/chargesLimit/paymentMethod.blade.php ENDPATH**/ ?>