<?php $__env->startSection('page_title',__('Dispute List')); ?>

<?php $__env->startSection('content'); ?>
	<div class="main-content">
		<section class="section">
			<div class="section-header">
				<h1><?php echo app('translator')->get('Dispute List'); ?></h1>
				<div class="section-header-breadcrumb">
					<div class="breadcrumb-item active">
						<a href="<?php echo e(route('user.dashboard')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
					</div>
					<div class="breadcrumb-item"><?php echo app('translator')->get('Dispute List'); ?></div>
				</div>
			</div>

			<div class="row mb-3">
				<div class="container-fluid" id="container-wrapper">
					<div class="row">
						<div class="col-lg-12">
							<div class="card mb-4 card-primary shadow-sm">
								<div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
									<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Search'); ?></h6>
								</div>
								<div class="card-body">
									<form action="<?php echo e(route('user.dispute.search')); ?>" method="get">
										<?php echo $__env->make('user.dispute.searchForm', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
									</form>
								</div>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-lg-12">
							<div class="card mb-4 card-primary shadow">
								<div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
									<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Dispute List'); ?></h6>
								</div>
								<div class="card-body">
									<div class="table-responsive">
										<table class="table table-striped table-hover align-items-center table-borderless">
											<thead class="thead-light">
											<tr>
												<th><?php echo app('translator')->get('Dispute For'); ?></th>
												<th><?php echo app('translator')->get('Dispute ID'); ?></th>
												<th><?php echo app('translator')->get('Status'); ?></th>
												<th><?php echo app('translator')->get('Created time'); ?></th>
												<th><?php echo app('translator')->get('Action'); ?></th>
											</tr>
											</thead>
											<tbody>
											<?php $__empty_1 = true; $__currentLoopData = $disputes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
												<tr>
													<td data-label="<?php echo app('translator')->get('Dispute For'); ?>">
														<?php if($value->disputable_type == \App\Models\Escrow::class): ?>
															<a href="<?php echo e(route('escrow.paymentView',optional($value->disputable)->utr)); ?>"><?php echo app('translator')->get('Escrow'); ?></a>
														<?php endif; ?>
													</td>
													<td data-label="<?php echo app('translator')->get('Dispute ID'); ?>"><?php echo e(__($value->utr)); ?></td>
													<td data-label="<?php echo app('translator')->get('Status'); ?>">
														<?php if($value->status == 0): ?>
															<span class="badge badge-success"><?php echo app('translator')->get('Open'); ?></span>
														<?php elseif($value->status == 1): ?>
															<span class="badge badge-info"><?php echo app('translator')->get('Solved'); ?></span>
														<?php elseif($value->status == 2): ?>
															<span class="badge badge-danger"><?php echo app('translator')->get('Close'); ?></span>
														<?php endif; ?>
													</td>
													<td data-label="<?php echo app('translator')->get('Created time'); ?>"><?php echo e(dateTime($value->created_at)); ?></td>
													<td data-label="<?php echo app('translator')->get('Action'); ?>">
														<a href="<?php echo e(route('user.dispute.view',optional($value->disputable)->utr)); ?>"
														class="btn btn-sm btn-outline-primary"><?php echo app('translator')->get('View'); ?></a>
													</td>
												</tr>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
												<tr>
													<th colspan="100%" class="text-center"><?php echo app('translator')->get('No data found'); ?></th>
												</tr>
											<?php endif; ?>
											</tbody>
										</table>
									</div>
									<div class="card-footer">
										<?php echo e($disputes->links()); ?>

									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

		</section>
	</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/user/dispute/index.blade.php ENDPATH**/ ?>