<?php $__env->startSection('page_title', __('Referral Bonus')); ?>

<?php $__env->startSection('content'); ?>
<div class="main-content">
	<section class="section">
		<div class="section-header">
			<h1><?php echo app('translator')->get('Referral Bonus'); ?></h1>
			<div class="section-header-breadcrumb">
				<div class="breadcrumb-item active">
					<a href="<?php echo e(route('admin.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
				</div>
				<div class="breadcrumb-item"><?php echo app('translator')->get('Referral Bonus'); ?></div>
			</div>
		</div>

		<div class="row mb-3">
			<div class="container-fluid" id="container-wrapper">
				<div class="row justify-content-md-center">
					<div class="col-lg-12">
						<div class="card mb-4 card-primary shadow">
							<div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
								<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Bonus on Add Fund'); ?></h6>
							</div>
							<div class="card-body parent">
								<div class="table-responsive--sm mt-2 mb-2">
									<table class="table table-striped table-hover table--light style--two">
										<thead>
										<tr>
											<th><?php echo app('translator')->get('Level'); ?></th>
											<th><?php echo app('translator')->get('Commission Amount'); ?></th>
											<th><?php echo app('translator')->get('Minimum Amount'); ?></th>
											<th><?php echo app('translator')->get('Status'); ?></th>
											<th><?php echo app('translator')->get('Type'); ?></th>
										</tr>
										</thead>
										<tbody>
										<?php $__currentLoopData = $referralBonuses->where('referral_on','deposit'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<tr>
												<td data-label="<?php echo app('translator')->get('Level'); ?>"><?php echo app('translator')->get('Level'); ?># <?php echo e(__($v->level)); ?></td>
												<td data-label="<?php echo app('translator')->get('Commission'); ?>"><?php echo e((getAmount($v->amount))); ?></td>
												<td data-label="<?php echo app('translator')->get('Minimum'); ?>"><?php echo e((getAmount($v->minAmount))); ?></td>
												<td data-label="<?php echo app('translator')->get('Status'); ?>">
													<?php if($v->status): ?>
														<?php echo app('translator')->get('Active'); ?>
													<?php else: ?>
														<?php echo app('translator')->get('Deactive'); ?>
													<?php endif; ?>
												</td>
												<td data-label="Type">
													<?php if($v->Type): ?>
														<?php echo app('translator')->get('Fixed'); ?>
													<?php else: ?>
														<?php echo app('translator')->get('Percent'); ?>
													<?php endif; ?>
												</td>
											</tr>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										</tbody>
									</table>
								</div>
								<hr>
								<div class="row mt-3 mb-5">
									<div class="col-md-6 mt-2">
										<input type="number" name="level" value="1" placeholder="<?php echo app('translator')->get('HOW MANY LEVEL'); ?>"
											   class="form-control levelGenerate">
									</div>
									<div class="col-md-6 mt-2">
										<button type="button" class="btn btn-sm btn-primary btn-block generate">
											<?php echo app('translator')->get('GENERATE'); ?>
										</button>
									</div>
								</div>
								<form action="<?php echo e(route('admin.referral.bonus.index')); ?>" method="post">
									<?php echo csrf_field(); ?>
									<input type="hidden" name="referral_on" class="referral_on" value="deposit">
									<div class="d-none levelForm">
										<div class="form-group">
											<label class="text-success"> <?php echo app('translator')->get('Level & Commission :'); ?>
												<small><?php echo app('translator')->get('(Old Levels will Remove After Generate)'); ?></small>
											</label>
											<div class="row">
												<div class="col-md-12">
													<div class="description referral-desc">
														<div class="row">
															<div class="col-md-12 planDescriptionContainer">
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>
										<button type="submit"
												class="btn btn-sm btn-primary btn-block my-3"><?php echo app('translator')->get('Save Changes'); ?></button>
									</div>
								</form>
							</div>
						</div>
					</div>

				</div>
			</div>
		</div>

	</section>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        "use strict";
        $(document).ready(function () {
            $(document).on('click', '.generate', function () {
                let levelGenerate = $(this).parents('.parent').find('.levelGenerate').val();
                let referral_on = $(this).parents('.parent').find('.referral_on').val();
                let a = 0;
                let val = 1;
                let viewHtml = '';
                if (levelGenerate !== '' && levelGenerate > 0) {
                    $(this).parents('.parent').find('.levelForm').removeClass('d-none');
                    $(this).parents('.parent').find('.levelForm').addClass('d-block');
                    for (a; a < parseInt(levelGenerate); a++) {
                        viewHtml += `<div class="input-group input-group-sm mt-4">
                            <div class="input-group-prepend">
                                <span class="input-group-text no-right-border"><?php echo app('translator')->get('LEVEL'); ?></span>
                            </div>
                            <input name="level[]" class="form-control margin-top-10 no-left-border width-120" type="number" readonly value="${val++}" required placeholder="<?php echo app('translator')->get('Level'); ?>">
                            <input name="amount[]" class="form-control margin-top-10" type="text" required placeholder="<?php echo app('translator')->get('Amount'); ?>">

                          	<select name="status[]" class="form-control form-control-sm">
                          	<option value="1"><?php echo app('translator')->get('Active'); ?></option>
                          	<option value="0"><?php echo app('translator')->get('Deactive'); ?></option>
							</select>
							${(referral_on !== 'login') ?
                            `<input name="minAmount[]" class="form-control margin-top-10" type="text" required placeholder="<?php echo app('translator')->get('Min Amount'); ?>">
								<select name="calcType[]" class="form-control form-control-sm">
									<option value="1"><?php echo app('translator')->get('Fixed'); ?></option>
									<option value="0"><?php echo app('translator')->get('Percent'); ?></option>
								</select>` : `<input type="hidden" name="calcType[]" value="1"><input type="hidden" name="minAmount[]" value="0">`}
							<span class="input-group-btn">
							<button class="btn btn-sm btn-danger margin-top-10 delete_desc" type="button"><i class='fa fa-minus'></i></button></span>
							</div>`;
                    }
                    $(this).parents('.parent').find('.planDescriptionContainer').html(viewHtml);
                } else {
                    alert('Level Field Is Required');
                }
            });

            $(document).on('click', '.delete_desc', function () {
                $(this).closest('.input-group').remove();
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/admin/referralBonus/show.blade.php ENDPATH**/ ?>