<?php $__env->startSection('page_title', __('Order Details')); ?>
<?php $__env->startSection('content'); ?>
	<div>
		<div class="main-content">
			<section class="section">
				<div class="section-header">
					<h1><?php echo app('translator')->get('Order Details'); ?></h1>
					<div class="section-header-breadcrumb">
						<div class="breadcrumb-item active">
							<a href="<?php echo e(route('admin.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
						</div>
						<div class="breadcrumb-item"><?php echo app('translator')->get('Order Details'); ?></div>
					</div>
				</div>
				<div class="section-body">
					<div class="row mt-sm-4">
						<div class="col-12 col-md-12 col-lg-12">
							<div class="container-fluid" id="container-wrapper">
								<div class="row justify-content-md-center">
									<div class="col-lg-8 col-md-8">
										<div class="card mb-4 card-primary shadow">
											<div
												class="card-header py-3 d-flex flex-wrap flex-row align-items-center justify-content-between">
												<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Order Number'); ?>
													- #<?php echo e($order->order_number); ?></h6>
												<div class="d-flex justify-content-end">
													<a href="<?php echo e(route('admin.order.list')); ?>"
													   class="btn btn-primary"><?php echo app('translator')->get('Back'); ?></a>
													<div class="dropdown ml-2 text-right">
														<div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
															<button class="dropdown-item processing" type="button"
																	data-toggle="modal"
																	data-target="#stageChange"><?php echo app('translator')->get('Processing'); ?></button>
															<button class="dropdown-item on-shipping" type="button"
																	data-toggle="modal"
																	data-target="#stageChange"><?php echo app('translator')->get('On Shipping'); ?></button>
															<button class="dropdown-item out-for-delivery" type="button"
																	data-toggle="modal"
																	data-target="#stageChange"><?php echo app('translator')->get('Out For Delivery'); ?></button>
															<button class="dropdown-item delivered" type="button"
																	data-toggle="modal"
																	data-target="#stageChange"><?php echo app('translator')->get('Delivered'); ?></button>
															<button class="dropdown-item cancel" type="button"
																	data-toggle="modal"
																	data-target="#stageChange"><?php echo app('translator')->get('Cancel'); ?></button>
														</div>
													</div>
												</div>
											</div>
											<div class="card-body">
												<div class="table-responsive">
													<table
														class="table table-striped table-hover align-items-center table-flush"
														id="data-table">
														<thead class="thead-light">
														<tr>
															<th><?php echo app('translator')->get('SL.'); ?></th>
															<th><?php echo app('translator')->get('Product Name'); ?></th>
															<th><?php echo app('translator')->get('Attributes'); ?></th>
															<th><?php echo app('translator')->get('Price'); ?></th>
															<th><?php echo app('translator')->get('Quantity'); ?></th>
															<th><?php echo app('translator')->get('Total Price'); ?></th>
														</tr>
														</thead>
														<tbody>
														<?php $__currentLoopData = $orderDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
															<tr>
																<td data-label="<?php echo app('translator')->get('SL.'); ?>"><?php echo e(++$key); ?></td>
																<td data-label="Product Name">
																	<a href="<?php echo e(route('product.view',$item->product_id)); ?>"
																	   class="text-decoration-none">
																		<div
																			class="d-lg-flex d-block align-items-center ">
																			<div class="mr-3"><img
																					src="<?php echo e(getFile(config('location.product.path').optional($item->product)->thumbnail)); ?>"
																					alt="user" class="rounded-circle"
																					width="40" data-toggle="tooltip"
																					title=""
																					data-original-title="<?php echo e(optional($item->product)->name); ?>">
																			</div>
																			<div
																				class="d-inline-flex d-lg-block align-items-center">
																				<p class="text-dark mb-0 font-16 font-weight-medium">
																					<?php echo e(optional($item->product)->name); ?></p>
																				<span
																					class="text-muted font-14 ml-1"><?php echo e(optional($item->product)->sku); ?></span>
																			</div>
																		</div>
																	</a>
																</td>
																<td data-label="<?php echo app('translator')->get('Attributes'); ?>"><?php $__currentLoopData = $item->attr; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
																		<span class="text-dark font-weight-bold"><?php echo e(optional($attr->attrName)->name); ?>:<?php echo e($attr->name); ?></span>
																	<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?></td>
																<td data-label="<?php echo app('translator')->get('Price'); ?>"><?php echo e(optional($item->order->user->storeCurrency)->symbol); ?><?php echo e(getAmount($item->price,2)); ?></td>
																<td data-label="<?php echo app('translator')->get('Quantity'); ?>"><?php echo e($item->quantity); ?></td>
																<td data-label="<?php echo app('translator')->get('Total Price'); ?>"><span
																		class="text-dark font-weight-bold"><?php echo e(optional($item->order->user->storeCurrency)->symbol); ?><?php echo e(getAmount($item->total_price,2)); ?></span>
																</td>
															</tr>
														<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
														</tbody>
													</table>
												</div>
											</div>
										</div>
									</div>
									<div class="col-md-4">
										<div class="card mb-4 card-primary shadow">
											<div
												class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
												<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Buyer Details'); ?></h6>
												<?php if($order->stage == ''): ?>
													<span
														class="badge badge-warning"><?php echo app('translator')->get('New Arrival'); ?></span>
												<?php elseif($order->stage == 1): ?>
													<span
														class="badge badge-info"><?php echo app('translator')->get('Processing'); ?></span>
												<?php elseif($order->stage == 2): ?>
													<span
														class="badge badge-dark"><?php echo app('translator')->get('On Shipping'); ?></span>
												<?php elseif($order->stage == 3): ?>
													<span
														class="badge badge-primary"><?php echo app('translator')->get('Out For Delivery'); ?></span>
												<?php elseif($order->stage == 4): ?>
													<span
														class="badge badge-success"><?php echo app('translator')->get('Delivered'); ?></span>
												<?php elseif($order->stage == 5): ?>
													<span
														class="badge badge-danger"><?php echo app('translator')->get('Cancel'); ?></span>
												<?php endif; ?>
											</div>
											<div class="card-body">
												<li class="list-group-item d-flex justify-content-between">
													<span><?php echo e(__('Full Name')); ?></span>
													<span class="text-info"><?php echo e($order->fullname??'N/A'); ?></span>
												</li>
												<li class="list-group-item d-flex justify-content-between">
													<span><?php echo e(__('Email')); ?></span>
													<span class="text-info"><?php echo e($order->email??'N/A'); ?></span>
												</li>
												<li class="list-group-item d-flex justify-content-between">
													<span><?php echo e(__('Phone')); ?></span>
													<span class="text-info"><?php echo e($order->phone??'N/A'); ?></span>
												</li>
												<li class="list-group-item d-flex justify-content-between">
													<span><?php echo e(__('Alt. Phone')); ?></span>
													<span class="text-info"><?php echo e($order->alt_phone??'N/A'); ?></span>
												</li>
												<?php if($order->shipping_id ): ?>
													<li class="list-group-item d-flex justify-content-between">
														<span><?php echo e(__('Shipping Address')); ?></span>
														<span
															class="text-info"><?php echo e(optional($order->shipping)->address??'N/A'); ?></span>
													</li>
												<?php endif; ?>
												<li class="list-group-item d-flex justify-content-between">
													<span><?php echo e(__('Details Address')); ?></span>
													<span class="text-info"><?php echo e($order->detailed_address??'N/A'); ?></span>
												</li>
												<li class="list-group-item d-flex justify-content-between">
													<span><?php echo e(__('Total Amount')); ?></span>
													<span
														class="text-info"><?php echo e(getAmount($order->total_amount,2)); ?> <?php echo e(optional($order->user->storeCurrency)->code); ?></span>
												</li>
												<?php if($order->shipping_charge > 0): ?>
													<li class="list-group-item d-flex justify-content-between">
														<span><?php echo e(__('Shipping Charge')); ?></span>
														<span
															class="text-danger"><?php echo e(getAmount($order->shipping_charge,2)); ?> <?php echo e(optional($order->user->storeCurrency)->code); ?></span>
													</li>
												<?php endif; ?>
												<li class="list-group-item d-flex justify-content-between">
													<span><?php echo e(__('Total Amount')); ?></span>
													<span
														class="text-dark font-weight-bold"><?php echo e(getAmount($order->total_amount+$order->shipping_charge,2)); ?> <?php echo e(optional($order->user->storeCurrency)->code); ?></span>
												</li>
												<li class="list-group-item d-flex justify-content-between">
													<span><?php echo e(__('Order Note')); ?></span>
													<span class="text-info"><?php echo e($order->order_note??'N/A'); ?></span>
												</li>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</section>
		</div>
	</div>
	<div id="stageChange" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="primary-header-modalLabel"
		 aria-hidden="true">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title text-dark font-weight-bold"
						id="primary-header-modalLabel"><?php echo app('translator')->get('Stage Change Confirmation'); ?></h4>
					<button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
				</div>
				<?php echo csrf_field(); ?>
				<div class="modal-body">
					<p><?php echo app('translator')->get('Are you want to change those orders stage?'); ?></p>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-dark" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
					<form action="<?php echo e(route('single.stage.change',$order->id)); ?>" method="post">
						<?php echo csrf_field(); ?>
						<input type="hidden" name="stage" class="stage" value="">
						<button type="submit" class="btn btn-primary change-yes"><?php echo app('translator')->get('Yes'); ?></button>
					</form>
				</div>
			</div>
		</div>
	</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('extra_scripts'); ?>
	<script src="<?php echo e(asset('assets/dashboard/js/jquery.dataTables.min.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/dashboard/js/dataTables.bootstrap4.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('scripts'); ?>
	<script>
		'use strict'
		$(document).on('click', '.processing', function () {
			$('.stage').val('processing');
		});
		$(document).on('click', '.on-shipping', function () {
			$('.stage').val('on-shipping');
		});
		$(document).on('click', '.out-for-delivery', function () {
			$('.stage').val('out-for-delivery');
		});
		$(document).on('click', '.delivered', function () {
			$('.stage').val('delivered');
		});
		$(document).on('click', '.cancel', function () {
			$('.stage').val('cancel');
		});
	</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/admin/store/orderView.blade.php ENDPATH**/ ?>