<div class="content active" id="tab1">
	<div class="invoice">
		<div class="container invoice-container">
			<header class="top">
				<div class="row">
					<div class="col-sm-6">
						<img src="<?php echo e(getFile(config('location.logo.path').'logo.png')); ?>"
							 alt="<?php echo e(config('basic.site_title')); ?>">
					</div>
					<div class="col-sm-6 text-sm-right">
						<h4><?php echo app('translator')->get('Invoice'); ?></h4>
						<p><?php echo app('translator')->get('Invoice Number'); ?> - {{item.invoiceNumber}}</p>
					</div>
				</div>
			</header>

			<main>
				<div class="row mt-3">
					<div class="col-sm-6">
						<h6><?php echo app('translator')->get('Pay To:'); ?></h6>
						<div>
							<span><?php echo e(auth()->user()->email); ?></span> <br/>
							<span><?php echo e(auth()->user()->mobile); ?></span> <br/>
						</div>
					</div>
					<div class="col-sm-6 text-sm-right">
						<h6><?php echo app('translator')->get('Invoiced To:'); ?></h6>
						<div>
							<span>{{ invoice.customer_email }}</span> <br/>
						</div>
					</div>
				</div>
				<div class="row my-3">
					<div class="col-sm-12 text-sm-right">
						<h6><?php echo app('translator')->get('Date:'); ?></h6>
						<span v-if="invoice.payment == 1">{{invoice.due_date}}</span>
						<span v-else>{{invoice.first_pay_date}}</span>
					</div>
				</div>
				<div class="card mt-3">
					<div class="card-header background">
						<h6 class="mb-0" class="item.frontColor"><?php echo app('translator')->get('Invoice Summary'); ?></h6>
					</div>
					<div class="card-body p-0">
						<div class="table-responsive invoice">
							<table class="table mb-0">
								<thead>
								<tr>
									<td class="col-8">
										<strong><?php echo app('translator')->get('Description'); ?></strong>
									</td>
									<td class="col-2 text-center">
										<strong><?php echo app('translator')->get('Title'); ?></strong>
									</td>
									<td class="col-2 text-right">
										<strong><?php echo app('translator')->get('Quantity'); ?></strong>
									</td>
									<td class="col-2 text-right">
										<strong><?php echo app('translator')->get('Price'); ?></strong>
									</td>
								</tr>
								</thead>
								<tbody>
								<tr v-for="(item, index) in invoice.items">
									<td>
										<span class="text-3">{{ item.description }}</span>
									</td>
									<td class="text-center">{{ item.title }}</td>
									<td class="text-right">{{ item.quantity }}</td>
									<td class="text-right">{{ symbol }}{{ item.price }}</td>
								</tr>
								</tbody>
								<tfoot class="card-footer background">
								<tr>
									<td colspan="3" class="text-right">
										<strong><?php echo app('translator')->get('Sub Total:'); ?></strong>
									</td>
									<td class="text-right">{{ symbol }}
										{{
										subtotal }}
									</td>
								</tr>
								<tr>
									<td colspan="3" class="text-right">
										<strong><?php echo app('translator')->get('Tax'); ?> ({{ taxRate }}%)</strong>
									</td>
									<td class="text-right">{{ symbol }}
										{{
										tax }}
									</td>
								</tr>
								<tr>
									<td colspan="3" class="text-right">
										<strong><?php echo app('translator')->get('Vat'); ?> ({{ vatRate }}%)</strong>
									</td>
									<td class="text-right">{{ symbol }}
										{{
										vat }}
									</td>
								</tr>
								<tr>
									<td
										colspan="3"
										class="text-right border-bottom-0">
										<strong><?php echo app('translator')->get('Total:'); ?></strong>
									</td>
									<td class="text-right border-bottom-0">
										{{ symbol }}{{grandTotal | decimalFiltered}}
									</td>
								</tr>
								</tfoot>
							</table>
						</div>
					</div>
				</div>
				<br/>
			</main>

			<!-- Footer -->
			<?php if(!request()->routeIs('invoice.view')): ?>
				<footer class="text-center">
					<div class="btn-group btn-group-sm d-print-none">
						<a :href="'<?php echo e(route('generatePdf')); ?>?invoice=' + encodeURIComponent(JSON.stringify({...invoice, ...item, tax, vat, subtotal, taxRate, vatRate, grandTotal,clickBtn:0}))"
						   target="_blank" class="btn btn-light">
							<i class="fas fa-print"></i>
							<?php echo app('translator')->get('Print'); ?>
						</a>
						<a :href="'<?php echo e(route('generatePdf')); ?>?invoice=' + encodeURIComponent(JSON.stringify({...invoice, ...item,tax, vat, subtotal, taxRate, vatRate, grandTotal,clickBtn:1}))"
						   class="btn btn-light">
							<i class="fas fa-download"></i>
							<?php echo app('translator')->get('Download'); ?>
						</a>
					</div>
				</footer>
			<?php endif; ?>
		</div>
	</div>
</div>


<?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/user/invoice/preview.blade.php ENDPATH**/ ?>