<?php $__env->startSection('page_title', __('Virtual-Card Settings')); ?>

<?php $__env->startSection('content'); ?>
	<div class="main-content">
		<section class="section">
			<div class="section-header">
				<h1><?php echo app('translator')->get('Virtual-Card Settings'); ?></h1>
				<div class="section-header-breadcrumb">
					<div class="breadcrumb-item active">
						<a href="<?php echo e(route('admin.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
					</div>
					<div class="breadcrumb-item"><?php echo app('translator')->get('Virtual-Card Settings'); ?></div>
				</div>
			</div>

			<div class="section-body">
				<div class="row mt-sm-4">
					<div class="col-12 col-md-4 col-lg-3">
						<?php echo $__env->make('admin.control_panel.components.sidebar', ['settings' => config('generalsettings.settings'), 'suffix' => 'Settings'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
					</div>
					<div class="col-12 col-md-8 col-lg-9">
						<div class="container-fluid" id="container-wrapper">
							<div class="row justify-content-md-center">
								<div class="col-lg-12">
									<div class="card mb-4 card-primary shadow">
										<div
											class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
											<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Virtual-Card Settings'); ?></h6>
										</div>
										<div class="card-body">
											<form action="<?php echo e(route('virtual-card.settings')); ?>" method="post">
												<?php echo csrf_field(); ?>
												<div class="row">
													<div class="col-md-6">
														<div class="form-group">
															<label>
																<?php echo app('translator')->get('Allow existing users on create multiple card'); ?>
															</label>
															<div class="selectgroup w-100">
																<label class="selectgroup-item">
																	<input type="radio" name="v_card_multiple" value="0"
																		   class="selectgroup-input" <?php echo e(old('v_card_multiple', $basicControl->v_card_multiple) == 0 ? 'checked' : ''); ?>>
																	<span class="selectgroup-button"><?php echo app('translator')->get('No'); ?></span>
																</label>
																<label class="selectgroup-item">
																	<input type="radio" name="v_card_multiple" value="1"
																		   class="selectgroup-input" <?php echo e(old('v_card_multiple', $basicControl->v_card_multiple) == 1 ? 'checked' : ''); ?>>
																	<span class="selectgroup-button"><?php echo app('translator')->get('Yes'); ?></span>
																</label>
															</div>
															<?php $__errorArgs = ['v_card_multiple'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
															<span class="text-danger" role="alert">
																<strong><?php echo e(__($message)); ?></strong>
															</span>
															<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
														</div>
													</div>
													<div class="col-md-6">
														<div class="form-group">
															<label>
																<?php echo app('translator')->get('Charges exiting users per card request'); ?>
															</label>
															<div class="input-group">
																<input type="number" class="form-control" step="0.001"
																	   name="v_card_charge"
																	   value="<?php echo e($basicControl->v_card_charge); ?>">
																<div class="input-group-prepend">
																	<span
																		class="form-control"><?php echo e(config('basic.base_currency_code')); ?></span>
																</div>
															</div>
															<?php $__errorArgs = ['v_card_charge'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
															<span class="text-danger" role="alert">
																<strong><?php echo e(__($message)); ?></strong>
															</span>
															<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
														</div>
													</div>
												</div>
												<input type="submit" id="submit"
													   class="btn btn-primary btn-sm btn-block"
													   value="<?php echo app('translator')->get('Save Changes'); ?>">
											</form>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
	</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
	<script>
		'use strict';
		$(document).ready(function () {
			$('[data-toggle="tooltip"]').tooltip();
		});
	</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/admin/control_panel/virtualCardSettings.blade.php ENDPATH**/ ?>