<!DOCTYPE html />
<!--[if lt IE 7 ]>
<html class="ie ie6" lang="en"> <![endif]-->
<!--[if IE 7 ]>
<html class="ie ie7" lang="en"> <![endif]-->
<!--[if IE 8 ]>
<html class="ie ie8" lang="en"> <![endif]-->
<!--[if (gte IE 9)|!(IE)]><!-->
<html class="no-js" lang="en" <?php if(session()->get('rtl') == 1): ?> dir="rtl" <?php endif; ?> >
<!--<![endif]-->
<head>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <link rel="preconnect" href="https://fonts.gstatic.com"/>
    <meta name="viewport" content="width=device-width, initial-scale=1"/>
    <meta name="keywords" content="<?php echo e(__($basicControl->meta_keywords)); ?>"/>
    <meta name="description" content="<?php echo e(__($basicControl->meta_description)); ?>">
    <meta name="keywords" content="<?php echo e(__($basicControl->meta_keywords)); ?>">
    <link rel="shortcut icon" href="<?php echo e(getFile(config('location.logo.path').'favicon.png')); ?>" type="image/x-icon">
    <link rel="apple-touch-icon" href="<?php echo e(getFile(config('location.logo.path').'favicon.png')); ?>">
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(getFile(config('location.logo.path').'favicon.png')); ?>">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black">
    <meta itemprop="description" content="<?php echo e(__($basicControl->meta_description)); ?>">
    <meta itemprop="image" content="<?php echo e(getFile(config('location.logo.path').'meta.png','600x315')); ?>">
    <meta property="og:type" content="website">
    <meta property="og:title" content="<?php echo e(__($basicControl->social_title)); ?>">
    <meta property="og:description" content="<?php echo e(__($basicControl->social_description)); ?>">
    <meta property="og:image" content="<?php echo e(getFile(config('location.logo.path') .'meta.png' )); ?>"/>
    <meta property="og:image:type"
          content="image/<?php echo e(pathinfo(getFile(config('location.logo.path') . 'meta.png' ))['extension']); ?>"/>
    <meta property="og:url" content="<?php echo e(url()->current()); ?>">
    <link href="<?php echo e(getFile(config('location.logo.path').'logo.png')); ?>" rel="icon">
    <title> <?php echo $__env->yieldContent('page_title'); ?> | <?php echo e(__($basicControl->site_title)); ?> </title>

	<?php echo $__env->make('frontend.layouts.styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!--[if lt IE 9]>
    <script type="application/javascript" src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
    <script type="application/javascript" src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
</head>

<body class="home">
	<?php echo $__env->make('frontend.layouts.topbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
	<?php $__env->startSection('content'); ?>
	<?php echo $__env->yieldSection(); ?>
	<?php echo $__env->make('frontend.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
	<?php echo $__env->make('frontend.layouts.scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
	<?php echo $__env->make('frontend.layouts.flash-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
	<?php echo $__env->yieldContent('scripts'); ?>
</body>
</html>
<?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/frontend/layouts/master.blade.php ENDPATH**/ ?>