<?php $__env->startSection('page_title', __('Charges & Limits')); ?>
<?php $__env->startPush('extra_styles'); ?>
	<link rel="stylesheet" href="<?php echo e(asset('assets/dashboard/css/dataTables.bootstrap4.min.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="main-content">
	<section class="section">
		<div class="section-header">
			<h1><?php echo app('translator')->get('Charges & Limits'); ?></h1>
			<div class="section-header-breadcrumb">
				<div class="breadcrumb-item active">
					<a href="<?php echo e(route('admin.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
				</div>
				<div class="breadcrumb-item"><?php echo app('translator')->get('Charges & Limits'); ?></div>
			</div>
		</div>


		<div class="section-body">
			<div class="row mt-sm-4">
				<div class="col-12 col-md-4 col-lg-3">
					<?php echo $__env->make('admin.control_panel.components.sidebar', ['settings' => config('generalsettings.settings'), 'suffix' => 'Settings'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
				</div>
				<div class="col-12 col-md-8 col-lg-9">
					<div class="container-fluid" id="container-wrapper">
						<div class="row justify-content-md-center">
							<div class="col-lg-12">
								<div class="card mb-4 card-primary shadow">
									<div class="card-header py-3 d-flex flex-wrap flex-row align-items-center justify-content-between">
										<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Charges & Limits'); ?></h6>
									</div>
									<div class="card-body">
										<div class="table-responsive">
											<table class="table table-striped table-hover align-items-center table-flush" id="data-table">
												<thead class="thead-light">
												<tr>
													<th><?php echo app('translator')->get('Name'); ?></th>
													<th><?php echo app('translator')->get('Txn Type'); ?></th>
													<th><?php echo app('translator')->get('Min/Max Limit'); ?></th>
													<th><?php echo app('translator')->get('Payment Method'); ?></th>
													<th><?php echo app('translator')->get('Charge'); ?> %</th>
													<th><?php echo app('translator')->get('Fixed Charge'); ?></th>
													<th><?php echo app('translator')->get('Logo'); ?></th>
													<th><?php echo app('translator')->get('Status'); ?></th>
													<th><?php echo app('translator')->get('Action'); ?></th>
												</tr>
												</thead>
												<tbody>
												<?php $__currentLoopData = $chargesLimits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $chargesLimit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
													<tr>
														<td data-label="<?php echo app('translator')->get('Name'); ?>"><?php echo e(__(optional($chargesLimit->currency)->name ?? __('N/A'))); ?></td>
														<td data-label="<?php echo app('translator')->get('Txn Type'); ?>"><?php echo e(__(ucfirst(array_search($chargesLimit->transaction_type_id, config('transactionType'))))); ?></td>
														<td data-label="<?php echo app('translator')->get('Min/Max Limit'); ?>"><?php echo e(getAmount($chargesLimit->min_limit)); ?> / <?php echo e(getAmount($chargesLimit->max_limit)); ?></td>
														<td data-label="<?php echo app('translator')->get('Payment Method'); ?>"><?php echo e(__(optional($chargesLimit->gateway)->name ?? __('N/A'))); ?></td>
														<td data-label="<?php echo app('translator')->get('Charge'); ?> %"><?php echo e(getAmount($chargesLimit->percentage_charge)); ?></td>
														<td data-label="<?php echo app('translator')->get('Fixed Charge'); ?>"><?php echo e(getAmount($chargesLimit->fixed_charge)); ?></td>
														<td data-label="<?php echo app('translator')->get('Logo'); ?>"><img class="img-profile-custom rounded-circle" src="<?php echo e(getFile(config('location.currencyLogo.path').optional($chargesLimit->currency)->logo)); ?>"></td>
														<td data-label="<?php echo app('translator')->get('Status'); ?>">
															<?php if($chargesLimit->is_active): ?>
																<span class="badge badge-info"><?php echo app('translator')->get('Active'); ?></span>
															<?php else: ?>
																<span class="badge badge-warning"><?php echo app('translator')->get('Inactive'); ?></span>
															<?php endif; ?>
														</td>
														<td data-label="<?php echo app('translator')->get('Action'); ?>">
															<a href="<?php echo e(route('charge.edit',$chargesLimit)); ?>" class="btn btn-sm btn-outline-primary"><i class="fas fa-edit"></i> <?php echo app('translator')->get('Edit'); ?></a>
														</td>
													</tr>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
												</tbody>
											</table>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

	</section>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('extra_scripts'); ?>
	<script src="<?php echo e(asset('assets/dashboard/js/jquery.dataTables.min.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/dashboard/js/dataTables.bootstrap4.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('scripts'); ?>
	<script>
		'use strict'
		$(document).ready(function (){
			$('#data-table').dataTable({
                "aaSorting": [],
                "ordering": false
			});
		});
	</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/admin/chargesLimit/index.blade.php ENDPATH**/ ?>