<?php $__env->startSection('page_title',__('Exchange Money')); ?>

<?php $__env->startSection('content'); ?>
	<div class="main-content">
		<section class="section">
			<div class="section-header">
				<h1><?php echo app('translator')->get('Exchange Money'); ?></h1>
				<div class="section-header-breadcrumb">
					<div class="breadcrumb-item active">
						<a href="<?php echo e(route('user.dashboard')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
					</div>
					<div class="breadcrumb-item"><?php echo app('translator')->get('Exchange Money'); ?></div>
				</div>
			</div>


			<!------ alert ------>
			<div class="row ">
				<div class="col-md-12">
					<div class="bd-callout bd-callout-primary mx-2">
						<i class="fa-3x fas fa-info-circle text-primary"></i> <?php echo app('translator')->get(@$template->description->short_description); ?>
					</div>
				</div>
			</div>


			<div class="row mb-3">
				<div class="container-fluid" id="container-wrapper">
					<div class="row justify-content-md-center">
						<div class="col-md-6">
							<div class="card mb-4 card-primary shadow">
								<div
									class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
									<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Exchange Money'); ?></h6>
								</div>
								<div class="card-body">
									<form action="<?php echo e(route('exchange.initialize')); ?>" method="post">
										<?php echo csrf_field(); ?>
										<div class="form-group search-currency-dropdown">
											<label for="from_wallet"><?php echo app('translator')->get('From Wallet'); ?></label>
											<select id="from_wallet" name="from_wallet"
													class="form-control form-control-sm">
												<option value="" disabled selected><?php echo app('translator')->get('Select wallet'); ?></option>
												<?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
													<option data-from_code="<?php echo e(__($currency->code)); ?>"
															data-currencytype="<?php echo e($currency->currency_type); ?>"
															value="<?php echo e($currency->id); ?>">
														<?php echo e(__($currency->code)); ?> - <?php echo e(__($currency->name)); ?> </option>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
											</select>
										</div>
										<div class="form-group search-currency-dropdown">
											<label for="to_wallet"><?php echo app('translator')->get('To Wallet'); ?></label>
											<select id="to_wallet" name="to_wallet"
													class="form-control form-control-sm">
											</select>
										</div>

										<div class="form-group">
											<label for="amount"><?php echo app('translator')->get('Amount'); ?></label>
											<input type="text" id="amount" value="<?php echo e(old('amount')); ?>" name="amount"
												   placeholder="<?php echo app('translator')->get('0.00'); ?>"
												   class="form-control <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
												   autocomplete="off">
											<div class="invalid-feedback">
												<?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
											</div>
											<div class="valid-feedback"></div>
										</div>

										<input type="submit" id="submit" class="btn btn-primary btn-sm btn-block"
											   value="<?php echo app('translator')->get('Exchange Money'); ?>" disabled>
									</form>
								</div>
							</div>
						</div>
						<div class="col-md-6">
							<div class="card mb-4 card-primary shadow">
								<div
									class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
									<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Transaction Details'); ?></h6>
								</div>
								<div class="card-body showCharge"></div>
							</div>
						</div>
					</div>
				</div>
			</div>

		</section>
	</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
	<script>
		'use strict';
		$(document).ready(function () {
			let from_walletField = $('#from_wallet');
			let to_walletField = $('#to_wallet');
			let amountField = $('#amount');
			$(document).on('change', '#from_wallet', function (e) {
				let from_wallet = from_walletField.val();
				if (from_wallet.length >= 1) {
					currenciesExceptSelected(from_wallet)
				} else {
					$('#to_wallet').html('<option value=""> Select from wallet </option>');
				}
			})

			$(document).on('change, input', '#to_wallet, #amount', function (e) {
				checkAmount();
			})

			function checkAmount() {
				let from_wallet = from_walletField.val();
				let from_code = $('#from_wallet option:selected').data('from_code');
				let to_code = $('#to_wallet option:selected').data('to_code');
				let currency_type = $('#from_wallet option:selected').data('currencytype');

				let to_wallet = to_walletField.val();
				let amount = amountField.val();
				if (amount > 0 && from_wallet && to_wallet && from_wallet.length >= 1 && to_wallet.length >= 1) {

					let fraction = amount.split('.')[1];
					let limit = currency_type == 0 ? 8 : 2;

					if (fraction && fraction.length > limit) {
						amount = (Math.floor(amount * Math.pow(10, limit)) / Math.pow(10, limit)).toFixed(limit);
						amountField.val(amount);
					}

					$.ajax({
						method: "GET",
						url: "<?php echo e(route('exchange.checkAmount')); ?>",
						dataType: "json",
						data: {
							'from_wallet': from_wallet,
							'to_wallet': to_wallet,
							'amount': amount,
						}
					})
						.done(function (response) {
							showCharge(response, from_code, to_code)
							if (response.status) {
								clearMessage(amountField)
								$(amountField).addClass('is-valid')
								$(amountField).closest('div').find(".valid-feedback").html(response.message)
								$("#submit").removeAttr("disabled");
							} else {
								clearMessage(amountField)
								$(amountField).addClass('is-invalid')
								$(amountField).closest('div').find(".invalid-feedback").html(response.message);
								$("#submit").attr("disabled", true);
							}
						});
				} else {
					clearMessage(amountField)
					$('.showCharge').html('')
				}
			}

			function showCharge(response, from_code, to_code) {
				let txnDetails = `
			<ul class="list-group">
				<li class="list-group-item d-flex justify-content-between align-items-center">
					<span><?php echo e(__('Available Balance')); ?></span>
					<span class="text-success">${response.balance} ${from_code}</span>
				</li>
				<li class="list-group-item d-flex justify-content-between align-items-center">
					<span><?php echo e(__('Transfer Charge')); ?></span>
					<span class="text-danger">${response.charge_percentage} + ${response.charge_fixed} = ${response.charge} ${from_code}</span>
				</li>
				<li class="list-group-item d-flex justify-content-between align-items-center">
					<span><?php echo e(__('Payable amount')); ?></span>
					<span class="text-info">${response.transfer_amount} ${from_code}</span>
				</li>
				<li class="list-group-item d-flex justify-content-between align-items-center">
					<span><?php echo e(__('You will get')); ?></span>
					<span class="text-info">${response.received_amount} ${to_code}</span>
				</li>
				<li class="list-group-item d-flex justify-content-between align-items-center">
					<span><?php echo e(__('Exchange rate')); ?></span>
					<span class="text-info">1 ${from_code} = ${response.exchange_rate} ${to_code}</span>
				</li>
				<li class="list-group-item d-flex justify-content-between align-items-center">
					<span><?php echo e(__('Remaining Balance')); ?></span>
					<span class="text-primary">${response.fromWalletUpdateBalance} ${from_code}</span>
				</li>
				<li class="list-group-item d-flex justify-content-between align-items-center">
					<span><?php echo e(__('Updated Balance')); ?></span>
					<span class="text-primary">${response.toWalletUpdateBalance} ${to_code}</span>
				</li>
				<li class="list-group-item d-flex justify-content-between align-items-center">
					<span><?php echo e(__('Min Request Limit')); ?></span>
					<span>${parseFloat(response.min_limit).toFixed(response.currency_limit)} ${from_code}</span>
				</li>
				<li class="list-group-item d-flex justify-content-between align-items-center">
					<span><?php echo e(__('Max Request Limit')); ?></span>
					<span>${parseFloat(response.max_limit).toFixed(response.currency_limit)} ${from_code}</span>
				</li>
			</ul>`
				$('.showCharge').html(txnDetails);
			}

			function currenciesExceptSelected(from_wallet) {
				$.ajax({
					method: "GET",
					url: "<?php echo e(route('currencies.except.selected')); ?>",
					dataType: "json",
					data: {
						'from_wallet': from_wallet
					}
				})
					.done(function (response) {
						if (response.status) {
							let options = '';
							if (response.to_wallet.length === 0) {
								options = '<option value="" disabled selected> <?php echo app('translator')->get('No Currency Available'); ?> </option>'
							} else {
								options += '<option value="" disabled selected><?php echo app('translator')->get('Select from wallet'); ?></option>'
								$.each(response.to_wallet, function (key, value) {
									options += '<option data-to_code="' + value.code + '" value="' + value.id + '">' + value.code + ' - ' + value.name + ' </option>'
								});
							}
							$('#to_wallet').html(options);
							checkAmount();
						}
					});
			}

			function clearMessage(fieldId) {
				$(fieldId).removeClass('is-valid')
				$(fieldId).removeClass('is-invalid')
				$(fieldId).closest('div').find(".invalid-feedback").html('');
				$(fieldId).closest('div').find(".is-valid").html('');
			}
		});
	</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/user/exchange/create.blade.php ENDPATH**/ ?>