<?php $__env->startSection('page_title',__('QR Payment List')); ?>

<?php $__env->startSection('content'); ?>
	<div class="main-content">
		<section class="section">
			<div class="section-header">
				<h1><?php echo app('translator')->get('QR Payment List'); ?></h1>
				<div class="section-header-breadcrumb">
					<div class="breadcrumb-item active">
						<a href="<?php echo e(route('user.dashboard')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
					</div>
					<div class="breadcrumb-item"><?php echo app('translator')->get('QR Payment List'); ?></div>
				</div>
			</div>

			<div class="row mb-3">
				<div class="container-fluid" id="container-wrapper">
					<div class="row">
						<div class="col-lg-12">
							<div class="card mb-4 card-primary shadow-sm">
								<div
									class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
									<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Search'); ?></h6>
								</div>
								<div class="card-body">
									<form action="<?php echo e(route('user.qr.payment')); ?>" method="get">
										<?php echo $__env->make('user.qrCode.searchForm', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
									</form>
								</div>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-lg-12">
							<div class="card mb-4 card-primary shadow">
								<div
									class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
									<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('QR Payment List'); ?></h6>
								</div>
								<div class="card-body">
									<div class="table-responsive">
										<table
											class="table table-striped table-hover align-items-center table-borderless">
											<thead class="thead-light">
											<tr>
												<th><?php echo app('translator')->get('SL.'); ?></th>
												<th><?php echo app('translator')->get('Sender Email'); ?></th>
												<th><?php echo app('translator')->get('Amount'); ?></th>
												<th><?php echo app('translator')->get('Charge'); ?></th>
												<th><?php echo app('translator')->get('Gateway'); ?></th>
												<th><?php echo app('translator')->get('Time'); ?></th>
											</tr>
											</thead>
											<tbody>
											<?php $__empty_1 = true; $__currentLoopData = $qrPayments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
												<tr>
													<td data-label="<?php echo app('translator')->get('SL.'); ?>"><?php echo e(++$key); ?></td>
													<td data-label="<?php echo app('translator')->get('Sender Email'); ?>"><?php echo e($value->email); ?></td>
													<td data-label="<?php echo app('translator')->get('Amount'); ?>"><?php echo e($value->amount); ?> <?php echo e(optional($value->currency)->code); ?></td>
													<td data-label="<?php echo app('translator')->get('Charge'); ?>">
														<span
															class="text-danger"><?php echo e($value->charge); ?> <?php echo e(optional($value->currency)->code); ?></span>
													</td>
													<td data-label="<?php echo app('translator')->get('Gateway'); ?>"><?php echo e(optional($value->gateway)->name); ?></td>
													<td data-label="<?php echo app('translator')->get('Time'); ?>"><?php echo e(dateTime($value->created_at)); ?></td>
												</tr>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
												<tr>
													<th colspan="100%" class="text-center"><?php echo app('translator')->get('No data found'); ?></th>
												</tr>
											<?php endif; ?>
											</tbody>
										</table>
									</div>
									<div class="card-footer">
										<?php echo e($qrPayments->links()); ?>

									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

		</section>
	</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/user/qrCode/index.blade.php ENDPATH**/ ?>