<?php $__env->startSection('page_title',__('Fund Added List')); ?>

<?php $__env->startSection('content'); ?>
	<!-- Main Content -->
	<div class="main-content">
		<section class="section">
			<div class="section-header">
				<h1><?php echo app('translator')->get('Fund Added List'); ?></h1>
				<div class="section-header-breadcrumb">
					<div class="breadcrumb-item active">
						<a href="<?php echo e(route('user.dashboard')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
					</div>
					<div class="breadcrumb-item"><?php echo app('translator')->get('Fund Added List'); ?></div>
				</div>
			</div>

			<div class="row mb-3">
				<div class="container-fluid" id="container-wrapper">
					<div class="row">
						<div class="col-lg-12">
							<div class="card card-primary mb-4 shadow-sm">
								<div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
									<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Search'); ?></h6>
								</div>
								<div class="card-body">
									<form action="<?php echo e(route('fund.search')); ?>" method="get">
										<?php echo $__env->make('user.fund.searchForm', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
									</form>
								</div>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-lg-12">
							<div class="card card-primary mb-4 shadow">
								<div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
									<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Fund Added List'); ?></h6>
								</div>
								<div class="card-body">
									<div class="table-responsive">
										<table class="table table-striped table-hover align-items-center table-borderless">
											<thead class="thead-light">
											<tr>
												<th><?php echo app('translator')->get('SL'); ?></th>
												<th><?php echo app('translator')->get('Method'); ?></th>
												<th><?php echo app('translator')->get('Transaction ID'); ?></th>
												<th><?php echo app('translator')->get('Requested Amount'); ?></th>
												<th><?php echo app('translator')->get('Status'); ?></th>
												<th><?php echo app('translator')->get('Created time'); ?></th>
											</tr>
											</thead>
											<tbody>
											<?php $__empty_1 = true; $__currentLoopData = $funds; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
												<tr>
													<td data-label="<?php echo app('translator')->get('SL'); ?>"><?php echo e(loopIndex($funds) + $key); ?></td>
													<td data-label="<?php echo app('translator')->get('Method'); ?>"><?php echo e(__(optional(optional($value->depositable)->gateway)->name) ?? __('N/A')); ?></td>
													<td data-label="<?php echo app('translator')->get('Transaction ID'); ?>"><?php echo e(__($value->utr)); ?></td>
													<td data-label="<?php echo app('translator')->get('Requested Amount'); ?>"><?php echo e((getAmount($value->amount)).' '.__(optional($value->currency)->code)); ?></td>
													<td data-label="<?php echo app('translator')->get('Status'); ?>">
														<?php if($value->status): ?>
															<span class="badge badge-success"><?php echo app('translator')->get('Success'); ?></span>
														<?php else: ?>
															<span class="badge badge-warning"><?php echo app('translator')->get('Pending'); ?></span>
														<?php endif; ?>
													</td>
													<td data-label="<?php echo app('translator')->get('Created time'); ?>"> <?php echo e(dateTime($value->created_at)); ?> </td>
												</tr>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
												<tr>
													<th colspan="100%" class="text-center"><?php echo app('translator')->get('No data found'); ?></th>
												</tr>
											<?php endif; ?>
											</tbody>
										</table>
									</div>
									<div class="card-footer">
										<?php echo e($funds->links()); ?>

									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

		</section>
	</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/user/fund/index.blade.php ENDPATH**/ ?>