<?php $__env->startSection('page_title',__('Staff List')); ?>

<?php $__env->startSection('content'); ?>
	<div id="manage-user-app">
		<div class="main-content">
			<section class="section">
				<div class="section-header">
					<h1><?php echo app('translator')->get('Staff List'); ?></h1>
					<div class="section-header-breadcrumb">
						<div class="breadcrumb-item active">
							<a href="<?php echo e(route('admin.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
						</div>
						<div class="breadcrumb-item"><?php echo app('translator')->get('Staff List'); ?></div>
					</div>
				</div>

				<div class="row mb-3">
					<div class="container-fluid" id="container-wrapper">
						<div class="row">
							<div class="col-lg-12">
								<div class="card mb-4 card-primary shadow">
									<div
										class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
										<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Staff List'); ?></h6>
										<button class="btn btn-sm btn-primary" data-target="#add-modal"
												data-toggle="modal" @click="makeDataEmpty"><?php echo app('translator')->get('Add New'); ?></button>
									</div>
									<div class="card-body">
										<div class="table-responsive">
											<table
												class="table table-striped table-hover align-items-center table-borderless">
												<thead class="thead-light">
												<tr>
													<th><?php echo app('translator')->get('SL.'); ?></th>
													<th><?php echo app('translator')->get('User'); ?></th>
													<th><?php echo app('translator')->get('Role'); ?></th>
													<th><?php echo app('translator')->get('Status'); ?></th>
													<th><?php echo app('translator')->get('Action'); ?></th>
												</tr>
												</thead>
												<tbody>
												<?php $__empty_1 = true; $__currentLoopData = $roleUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
													<tr>
														<td data-label="<?php echo app('translator')->get('SL.'); ?>"><?php echo e(++$key); ?></td>
														<td data-label="<?php echo app('translator')->get('User'); ?>">
															<a href="javascript:void(0)"
															   class="text-decoration-none">
																<div class="d-lg-flex d-block align-items-center ">
																	<div class="mr-3"><img
																			src="<?php echo e($value->profilePicture()??asset('assets/upload/boy.png')); ?>"
																			alt="user"
																			class="rounded-circle" width="35"
																			data-toggle="tooltip" title=""
																			data-original-title="<?php echo e($value->name?? __('N/A')); ?>">
																	</div>
																	<div
																		class="d-inline-flex d-lg-block align-items-center">
																		<p class="text-dark mb-0 font-16 font-weight-medium"><?php echo e(Str::limit($value->name?? __('N/A'),20)); ?></p>
																		<span
																			class="text-muted font-14 ml-1"><?php echo e('@'.$value->username?? __('N/A')); ?></span>
																	</div>
																</div>
															</a>
														</td>
														<td data-label="<?php echo app('translator')->get('Role'); ?>">
															<span
																class="badge badge-primary"><?php echo e(str_replace('_',' ',ucfirst(optional($value->role)->name))); ?></span>
														</td>
														<td data-label="<?php echo app('translator')->get('Status'); ?>">
															<?php if($value->status == 1): ?>
																<span class="badge badge-success"><?php echo app('translator')->get('Active'); ?></span>
															<?php else: ?>
																<span
																	class="badge badge-danger"><?php echo app('translator')->get('Inactive'); ?></span>
															<?php endif; ?>
														</td>
														<td data-label="<?php echo app('translator')->get('Action'); ?>">
															<button data-target="#login_as" data-toggle="modal"
																	data-route="<?php echo e(route('admin.role.usersLogin',$value->id)); ?>"
																	class="btn btn-sm btn-outline-primary loginUser"><?php echo app('translator')->get('Login As Staff'); ?></button>
															<?php if($value->status == 0): ?>
																<button data-target="#status_change" data-toggle="modal"
																		data-route="<?php echo e(route('admin.role.statusChange',$value->id)); ?>"
																		class="btn btn-sm btn-outline-success enableStatus">
																	<i
																		class="fas fa-check-circle"></i> <?php echo app('translator')->get('Active'); ?>
																</button>
															<?php else: ?>
																<button data-target="#status_change" data-toggle="modal"
																		data-route="<?php echo e(route('admin.role.statusChange',$value->id)); ?>"
																		class="btn btn-sm btn-outline-danger disableStatus">
																	<i
																		class="fas fa-times"></i> <?php echo app('translator')->get('Inactive'); ?>
																</button>
															<?php endif; ?>
														</td>
													</tr>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
													<tr>
														<th colspan="100%"
															class="text-center"><?php echo app('translator')->get('No data found'); ?></th>
													</tr>
												<?php endif; ?>
												</tbody>
											</table>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</section>
		</div>
		<div id="add-modal" class="modal fade" tabindex="-1" role="dialog"
			 aria-labelledby="primary-header-modalLabel"
			 aria-hidden="true">
			<div class="modal-dialog">
				<div class="modal-content">
					<div class="modal-header">
						<h4 class="modal-title text-dark font-weight-bold"
							id="primary-header-modalLabel"><?php echo app('translator')->get('Add Staffs'); ?></h4>
						<button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
					</div>
					<form>
						<div class="modal-body">
							<?php if($roles): ?>
								<div class="col-12">
									<label for=""><?php echo app('translator')->get('Role'); ?> </label>
									<select
										class="form-select form-control"
										v-model="item.role"
										aria-label="Default select example">
										<option selected disabled><?php echo app('translator')->get('Select Role'); ?></option>
										<?php $__empty_1 = true; $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
											<option value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?></option>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
										<?php endif; ?>
									</select>
									<span class="text-danger role-error"></span>
								</div>
							<?php endif; ?>
							<div class="col-12 mt-3">
								<label for=""><?php echo app('translator')->get('Name'); ?></label>
								<input
									type="text"
									class="form-control" v-model="item.name"
									placeholder="<?php echo app('translator')->get('Name'); ?>"/>
								<span class="text-danger name-error"></span>
							</div>
							<div class="col-12 mt-3">
								<label for=""><?php echo app('translator')->get('Email'); ?></label>
								<input
									type="text"
									class="form-control" v-model="item.email"
									placeholder="<?php echo app('translator')->get('Email'); ?>"/>
								<span class="text-danger email-error"></span>
							</div>
							<div class="col-12 mt-3">
								<label for=""><?php echo app('translator')->get('Username'); ?></label>
								<input
									type="text"
									class="form-control" v-model="item.username"
									placeholder="<?php echo app('translator')->get('Username'); ?>"/>
								<span class="text-danger username-error"></span>
							</div>
							<div class="col-12 mt-3">
								<label for=""><?php echo app('translator')->get('Password'); ?></label>
								<input
									type="text"
									class="form-control" v-model="item.password"
									placeholder="<?php echo app('translator')->get('Password'); ?>"/>
								<span class="text-danger password-error"></span>
							</div>
							<div class="col-md-12 my-3">
								<label for=""><?php echo app('translator')->get('Status'); ?> </label>
								<div class="selectgroup w-100">
									<label class="selectgroup-item">
										<input type="radio" v-model="item.status" value="0" class="selectgroup-input">
										<span class="selectgroup-button"><?php echo app('translator')->get('OFF'); ?></span>
									</label>
									<label class="selectgroup-item">
										<input type="radio" v-model="item.status" value="1" class="selectgroup-input"
											   :checked="item.status == 1">
										<span class="selectgroup-button"><?php echo app('translator')->get('ON'); ?></span>
									</label>
								</div>
							</div>
						</div>
						<div class="modal-footer">
							<button type="button" class="btn btn-dark" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
							<button type="button" class="btn btn-primary"
									@click.prevent="userSubmit"><?php echo app('translator')->get('save'); ?></button>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
	
	<div id="status_change" class="modal fade" tabindex="-1" role="dialog"
		 aria-labelledby="primary-header-modalLabel"
		 aria-hidden="true">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title text-dark font-weight-bold"
						id="primary-header-modalLabel"><?php echo app('translator')->get('Status Change Confirmation'); ?></h4>
					<button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
				</div>
				<form action="" method="post" class="statusRoute">
					<?php echo csrf_field(); ?>
					<div class="modal-body">
						<div id="tag-body">
						</div>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-dark" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
						<button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Submit'); ?></button>
					</div>
				</form>
			</div>
		</div>
	</div>
	
	<div id="login_as" class="modal fade" tabindex="-1" role="dialog"
		 aria-labelledby="primary-header-modalLabel"
		 aria-hidden="true">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title text-dark font-weight-bold"
						id="primary-header-modalLabel"><?php echo app('translator')->get('Login as user'); ?></h4>
					<button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
				</div>
				<form action="" method="post" class="loginRoute">
					<?php echo csrf_field(); ?>
					<div class="modal-body">
						<p><?php echo app('translator')->get('Are you sure want to login as user'); ?></p>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-dark" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
						<button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Submit'); ?></button>
					</div>
				</form>
			</div>
		</div>
	</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('extra_scripts'); ?>
	<script>
		'use strict'
		$(document).on('click', '.enableStatus', function () {
			$('#tag-body').html('');
			var route = $(this).data('route');
			$('.statusRoute').attr('action', route)
			$('#tag-body').append(`<p>Are you sure active this staff<p>`)
		});

		$(document).on('click', '.disableStatus', function () {
			$('#tag-body').html('');
			var route = $(this).data('route');
			$('.statusRoute').attr('action', route)
			$('#tag-body').append(`<p>Are you sure inactive this staff<p>`)
		});

		$(document).on('click', '.loginUser', function () {
			var route = $(this).data('route');
			$('.loginRoute').attr('action', route)
		});

		var newApp = new Vue({
			el: "#manage-user-app",
			data: {
				item: {
					name: "", email: "", username: "", password: "", role: "",
					id: "",
					status: "",
				}
			},
			mounted() {
				this.item.status = 1;
			},
			methods: {
				userSubmit() {
					var $url = '<?php echo e(route('admin.role.usersCreate')); ?>'
					axios.post($url, this.item)
						.then(function (response) {
							if (response.data.result) {
								location.reload();
							}
						})
						.catch(function (error) {
							let errors = error.response.data;
							errors = errors.errors
							for (let err in errors) {
								let selector = document.querySelector(`.${err}-error`);
								if (selector) {
									selector.innerText = `${errors[err]}`;
								}
							}
						});
				},
				makeDataEmpty() {
					this.item.name = "";
					this.item.email = "";
					this.item.username = "";
					this.item.password = "";
					this.item.id = "";
				},
				editRole(obj) {
					this.makeDataEmpty();
					this.item.name = obj.name;
					this.item.id = obj.id;
					this.item.status = obj.status;
					this.item.permissions = obj.permission;
					if (0 < obj.permission.length) {
						obj.permission.map(function (obj, i) {
							$(`.permission-check[value="${obj}"]`).attr('checked', 'checked');
						});
					}
				},
				rolePermissionUpdate() {
					var $url = '<?php echo e(route('admin.role.update')); ?>'
					axios.post($url, this.item)
						.then(function (response) {
							if (response.data.result) {
								location.reload();
							}
						})
						.catch(function (error) {
							let errors = error.response.data;
							errors = errors.errors
							for (let err in errors) {
								let selector = document.querySelector(`.${err}-error`);
								if (selector) {
									selector.innerText = `${errors[err]}`;
								}
							}
						});
				},
			}
		})
	</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/admin/role_permission/userList.blade.php ENDPATH**/ ?>