<?php $__env->startSection('page_title',__('Escrow lists')); ?>

<?php $__env->startSection('content'); ?>
<div class="main-content">
	<section class="section">
		<div class="section-header">
			<h1><?php echo app('translator')->get('Escrow Lists'); ?></h1>
			<div class="section-header-breadcrumb">
				<div class="breadcrumb-item active">
					<a href="<?php echo e(route('user.dashboard')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
				</div>
				<div class="breadcrumb-item"><?php echo app('translator')->get('Escrow Lists'); ?></div>
			</div>
		</div>

		<div class="row mb-3">
			<div class="container-fluid" id="container-wrapper">
				<div class="row">
					<div class="col-lg-12">
						<div class="card mb-4 shadow-sm card-primary">
							<div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
								<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Search'); ?></h6>
							</div>
							<div class="card-body">
								<form action="<?php echo e(route('escrow.search')); ?>" method="get">
									<?php echo $__env->make('user.escrow.searchForm', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
								</form>
							</div>
						</div>
					</div>
				</div>
				<div class="row">
					<div class="col-lg-12">
						<div class="card mb-4 card-primary shadow">
							<div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
								<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Escrow lists'); ?></h6>
							</div>
							<div class="card-body">
								<div class="table-responsive">
									<table class="table table-striped table-hover align-items-center table-borderless">
										<thead class="thead-light">
										<tr>
											<th><?php echo app('translator')->get('SL'); ?></th>
											<th><?php echo app('translator')->get('Receiver'); ?></th>
											<th><?php echo app('translator')->get('Receiver E-Mail'); ?></th>
											<th><?php echo app('translator')->get('Transaction ID'); ?></th>
											<th><?php echo app('translator')->get('Amount'); ?></th>
											<th><?php echo app('translator')->get('Type'); ?></th>
											<th><?php echo app('translator')->get('Status'); ?></th>
											<th><?php echo app('translator')->get('Created time'); ?></th>
											<th><?php echo app('translator')->get('Action'); ?></th>
										</tr>
										</thead>
										<tbody>
										<?php $__empty_1 = true; $__currentLoopData = $escrows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $escrow): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
											<tr>
												<td data-label="<?php echo app('translator')->get('SL'); ?>"><?php echo e(loopIndex($escrows) + $key); ?></td>
												<td data-label="<?php echo app('translator')->get('Receiver'); ?>"><?php echo e(__(optional($escrow->receiver)->name) ?? __('N/A')); ?></td>
												<td data-label="<?php echo app('translator')->get('Receiver E-Mail'); ?>"><?php echo e(__($escrow->email)); ?></td>
												<td data-label="<?php echo app('translator')->get('Transaction ID'); ?>"><?php echo e(__($escrow->utr)); ?></td>
												<td data-label="<?php echo app('translator')->get('Amount'); ?>"><?php echo e((getAmount($escrow->amount)) .' '. __(optional($escrow->currency)->code)); ?></td>
												<td data-label="<?php echo app('translator')->get('Type'); ?>">
													<?php if($escrow->sender_id == Auth::id()): ?>
														<span class="badge badge-info"><?php echo app('translator')->get('Sent'); ?></span>
													<?php else: ?>
														<span class="badge badge-success"><?php echo app('translator')->get('Received'); ?></span>
													<?php endif; ?>
												</td>
												<td data-label="<?php echo app('translator')->get('Status'); ?>">
													<?php if($escrow->status == 0): ?>
														<span class="badge badge-warning"><?php echo app('translator')->get('Pending'); ?></span>
													<?php elseif($escrow->status == 1): ?>
														<span class="badge badge-primary"><?php echo app('translator')->get('Generated'); ?></span>
													<?php elseif($escrow->status == 2): ?>
														<span class="badge badge-secondary"><?php echo app('translator')->get('Deposited'); ?></span>
													<?php elseif($escrow->status == 3): ?>
														<span class="badge badge-info"><?php echo app('translator')->get('Request for payment'); ?></span>
													<?php elseif($escrow->status == 4): ?>
														<span class="badge badge-success"><?php echo app('translator')->get('Payment Disbursed'); ?></span>
													<?php elseif($escrow->status == 5): ?>
														<span class="badge badge-danger"><?php echo app('translator')->get('Canceled'); ?></span>
													<?php elseif($escrow->status == 6 && optional($escrow->disputable)->status == 0): ?>
														<?php if($escrow->sender_id == Auth::id()): ?>
															<span class="badge badge-warning"><?php echo app('translator')->get('Hold'); ?></span>
														<?php elseif($escrow->receiver_id == Auth::id()): ?>
															<span class="badge badge-warning"><?php echo app('translator')->get('Dispute'); ?></span>
														<?php endif; ?>
													<?php elseif($escrow->status == 6 && optional($escrow->disputable)->status == 1): ?>
														<span class="badge badge-warning"><?php echo app('translator')->get('Dispute'); ?></span> <span
																class="badge badge-info"><?php echo app('translator')->get('Refunded'); ?></span>
													<?php elseif($escrow->status == 6 && optional($escrow->disputable)->status == 2): ?>
														<span class="badge badge-warning"><?php echo app('translator')->get('Dispute'); ?></span> <span
																class="badge badge-info"><?php echo app('translator')->get('Payment Disbursed'); ?></span>
													<?php else: ?>
														<span class="badge badge-dark"><?php echo app('translator')->get('N/A'); ?></span>
													<?php endif; ?>
												</td>
												<td data-label="<?php echo app('translator')->get('Created time'); ?>"> <?php echo e(__(date('Y-m-d h:i a',strtotime($escrow->created_at)))); ?> </td>
												<td data-label="<?php echo app('translator')->get('Action'); ?>">
													<?php if($escrow->status != 0): ?>
														<a href="<?php echo e(route('escrow.paymentView',$escrow->utr)); ?>"
														   class="btn btn-sm btn-info"> <?php echo app('translator')->get('View'); ?></a>
													<?php else: ?>
														<a href="<?php echo e(route('escrow.confirmInit',$escrow->utr)); ?>" target="_blank"
														   class="btn btn-sm btn-primary"><?php echo app('translator')->get('Generate'); ?></a>
													<?php endif; ?>
												</td>
											</tr>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
											<tr>
												<th colspan="100%" class="text-center"><?php echo app('translator')->get('No data found'); ?></th>
											</tr>
										<?php endif; ?>
										</tbody>
									</table>
								</div>
								<div class="card-footer">
									<?php echo e($escrows->links()); ?>

								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

	</section>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/user/escrow/index.blade.php ENDPATH**/ ?>