<?php $__env->startSection('page_title',__('Request Money List')); ?>

<?php $__env->startSection('content'); ?>
	<div class="main-content">
		<section class="section">
			<div class="section-header">
				<h1><?php echo app('translator')->get('Request Money List'); ?></h1>
				<div class="section-header-breadcrumb">
					<div class="breadcrumb-item active">
						<a href="<?php echo e(route('user.dashboard')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
					</div>
					<div class="breadcrumb-item"><?php echo app('translator')->get('Request Money List'); ?></div>
				</div>
			</div>

			<div class="container-fluid" id="container-wrapper">
				<div class="row">
					<div class="col-lg-12">
						<div class="card mb-4 card-primary shadow-sm">
							<div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
								<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Search'); ?></h6>
							</div>
							<div class="card-body">
								<form action="<?php echo e(route('requestMoney.search')); ?>" method="get">
									<div class="row">
										<div class="col-md-2">
											<div class="form-group">
												<input placeholder="<?php echo app('translator')->get('Sender'); ?>" name="sender"
													   value="<?php echo e($search['sender'] ?? ''); ?>" type="text"
													   class="form-control form-control-sm">
											</div>
										</div>
										<div class="col-md-2">
											<div class="form-group">
												<input placeholder="<?php echo app('translator')->get('Receiver'); ?>" name="receiver"
													   value="<?php echo e($search['receiver'] ?? ''); ?>" type="text"
													   class="form-control form-control-sm">
											</div>
										</div>
										<div class="col-md-2">
											<div class="form-group">
												<input placeholder="<?php echo app('translator')->get('E-mail'); ?>" name="email"
													   value="<?php echo e($search['email'] ?? ''); ?>" type="text"
													   class="form-control form-control-sm">
											</div>
										</div>
										<div class="col-md-2">
											<div class="form-group">
												<input placeholder="<?php echo app('translator')->get('Transaction ID'); ?>" name="utr"
													   value="<?php echo e($search['utr'] ?? ''); ?>" type="text"
													   class="form-control form-control-sm">
											</div>
										</div>
										<div class="col-md-2">
											<div class="form-group">
												<input placeholder="<?php echo app('translator')->get('Min Amount'); ?>" name="min"
													   value="<?php echo e($search['min'] ?? ''); ?>" type="text"
													   class="form-control form-control-sm">
											</div>
										</div>
										<div class="col-md-2">
											<div class="form-group">
												<input placeholder="<?php echo app('translator')->get('Maximum Amount'); ?>" name="max"
													   value="<?php echo e($search['max'] ?? ''); ?>" type="text"
													   class="form-control form-control-sm">
											</div>
										</div>
										<div class="col-md-2">
											<div class="form-group">
												<input placeholder="<?php echo app('translator')->get('Transaction Date'); ?>" name="created_at" id="created_at"
													   value="<?php echo e($search['created_at'] ?? ''); ?>" type="date"
													   class="form-control form-control-sm" autocomplete="off">
											</div>
										</div>
										<div class="col-md-2">
											<div class="form-group search-currency-dropdown">
												<select name="currency_id" class="form-control form-control-sm">
													<option value=""><?php echo app('translator')->get('All Currency'); ?></option>
													<?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
														<option value="<?php echo e($currency->id); ?>" <?php echo e(isset($search['currency_id']) && $search['currency_id'] == $currency->id ? 'selected' : ''); ?>> <?php echo e(__($currency->code)); ?>

															- <?php echo e(__($currency->name)); ?> </option>
													<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
												</select>
											</div>
										</div>
										<div class="col-md-2">
											<div class="form-group search-currency-dropdown">
												<select name="type" class="form-control form-control-sm">
													<option value=""><?php echo app('translator')->get('All Type'); ?></option>
													<option value="sent" <?php echo e(isset($search['type']) && $search['type'] == 'sent' ? 'selected' : ''); ?>><?php echo app('translator')->get('Sent'); ?></option>
													<option value="received" <?php echo e(isset($search['type']) && $search['type'] == 'received' ? 'selected' : ''); ?>><?php echo app('translator')->get('Received'); ?></option>
												</select>
											</div>
										</div>
										<div class="col-md-2">
											<div class="form-group">
												<button type="submit"
														class="btn btn-primary btn-sm btn-block"><?php echo app('translator')->get('Search'); ?></button>
											</div>
										</div>
									</div>
								</form>
							</div>
						</div>
					</div>
				</div>
				<div class="row">
					<div class="col-lg-12">
						<div class="card mb-4 card-primary shadow">
							<div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
								<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Request Money'); ?></h6>
							</div>
							<div class="card-body">
								<div class="table-responsive">
									<table class="table table-striped table-hover align-items-center table-borderless">
										<thead class="thead-light">
										<tr>
											<th><?php echo app('translator')->get('SL'); ?></th>
											<th><?php echo app('translator')->get('Request To'); ?></th>
											<th><?php echo app('translator')->get('Sender E-Mail'); ?></th>
											<th><?php echo app('translator')->get('Transaction ID'); ?></th>
											<th><?php echo app('translator')->get('Amount'); ?></th>
											<th><?php echo app('translator')->get('Status'); ?></th>
											<th><?php echo app('translator')->get('Created time'); ?></th>
											<th><?php echo app('translator')->get('Action'); ?></th>
										</tr>
										</thead>
										<tbody>
										<?php $__empty_1 = true; $__currentLoopData = $requestMoney; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
											<tr>
												<td data-label="<?php echo app('translator')->get('SL'); ?>"><?php echo e(loopIndex($requestMoney) + $key); ?></td>
												<td data-label="<?php echo app('translator')->get('Request To'); ?>"><?php echo e(__(optional($value->receiver)->name) ?? __('N/A')); ?></td>
												<td data-label="<?php echo app('translator')->get('Sender E-Mail'); ?>"><?php echo e(__($value->email)); ?></td>
												<td data-label="<?php echo app('translator')->get('Transaction ID'); ?>"><?php echo e(__($value->utr)); ?></td>
												<td data-label="<?php echo app('translator')->get('Amount'); ?>"><?php echo e((getAmount($value->amount)).' '.__(optional($value->currency)->code)); ?></td>
												<td data-label="<?php echo app('translator')->get('Status'); ?>">
													<?php if($value->status == 1): ?>
														<span class="badge badge-info"><?php echo app('translator')->get('Success'); ?></span>
													<?php elseif($value->status == 2): ?>
														<span class="badge badge-danger"><?php echo app('translator')->get('Canceled'); ?></span>
													<?php else: ?>
														<span class="badge badge-warning"><?php echo app('translator')->get('Pending'); ?></span>
													<?php endif; ?>
												</td>
												<td data-label="<?php echo app('translator')->get('Created time'); ?>"> <?php echo e(dateTime($value->created_at)); ?> </td>
												<td data-label="<?php echo app('translator')->get('Action'); ?>">
													<?php if($value->receiver_id == Auth::id()): ?>
														<a href="<?php echo e(route('requestMoney.check',[$value->utr])); ?>"
														   class="btn btn-sm btn-primary"><?php echo app('translator')->get('Yes'); ?></a>
													<?php endif; ?>
													<?php if($value->status == 0): ?>
														<a href="<?php echo e(route('requestMoney.cancel',[$value->utr])); ?>"
														   class="btn btn-sm btn-danger cancelButton" data-toggle="modal"
														   data-target="#cancelModal"><?php echo app('translator')->get('Cancel'); ?></a>
													<?php endif; ?>
												</td>
											</tr>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
											<tr>
												<th colspan="100%" class="text-center"><?php echo app('translator')->get('No data found'); ?></th>
											</tr>
										<?php endif; ?>
										</tbody>
									</table>
								</div>
								<div class="card-footer">
									<?php echo e($requestMoney->links()); ?>

								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
	</div>

	<!----- Cancel Modal ----->
	<div class="modal fade" id="cancelModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
	aria-hidden="true">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title text-danger" id="exampleModalLabel"><?php echo app('translator')->get('Confirmation !'); ?></h5>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true"><?php echo app('translator')->get('&times;'); ?></span>
					</button>
				</div>
				<div class="modal-body text-center">
					<p><?php echo app('translator')->get('Do you want to cancel this request?'); ?></p>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-outline-primary" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
					<a href="" class="btn btn-primary" id="cancelButton"><?php echo app('translator')->get('Confirmed'); ?></a>
				</div>
			</div>
		</div>
	</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        'use strict';
        $(document).ready(function () {
            $(document).on('click', '.cancelButton', function (e) {
                let cancelUrl = $(this).attr('href');
                $('#cancelButton').attr('href', cancelUrl)
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/user/requestMoney/index.blade.php ENDPATH**/ ?>