<?php $__env->startSection('page_title', __('Products List')); ?>
<?php $__env->startSection('content'); ?>
	<div class="main-content" id="store" v-cloak>
		<section class="section">
			<div class="section-header">
				<h1><?php echo app('translator')->get('Products List'); ?></h1>
				<div class="section-header-breadcrumb">
					<div class="breadcrumb-item active">
						<a href="<?php echo e(route('user.dashboard')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
					</div>
					<div class="breadcrumb-item"><?php echo app('translator')->get('Products List'); ?></div>
				</div>
			</div>
			<div class="section-body">
				<div class="row mt-sm-4">
					<div class="col-12 col-md-12 col-lg-12">
						<div class="container-fluid" id="container-wrapper">
							<div class="row">
								<div class="col-lg-12">
									<div class="card mb-4 card-primary shadow-sm">
										<div
											class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
											<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Search'); ?></h6>
										</div>
										<div class="card-body">
											<form action="<?php echo e(route('admin.product.list')); ?>" method="get">
												<?php echo $__env->make('admin.store.product.searchForm', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
											</form>
										</div>
									</div>
								</div>
							</div>
							<div class="row justify-content-md-center">
								<div class="col-lg-12">
									<div class="card mb-4 card-primary shadow">
										<div class="card-body">
											<div class="table-responsive">
												<table
													class="table table-striped table-hover align-items-center table-flush"
													id="data-table">
													<thead class="thead-light">
													<tr>
														<th><?php echo app('translator')->get('SL.'); ?></th>
														<th><?php echo app('translator')->get('User'); ?></th>
														<th><?php echo app('translator')->get('Product'); ?></th>
														<th><?php echo app('translator')->get('Category'); ?></th>
														<th><?php echo app('translator')->get('Currency'); ?></th>
														<th><?php echo app('translator')->get('Price'); ?></th>
														<th><?php echo app('translator')->get('Status'); ?></th>
														<th><?php echo app('translator')->get('Action'); ?></th>
													</tr>
													</thead>
													<tbody>
													<?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
														<tr>
															<td data-label="<?php echo app('translator')->get('SL.'); ?>"><?php echo e(++$key); ?></td>
															<td data-label="<?php echo app('translator')->get('User'); ?>">
																<a href="<?php echo e(route('user.edit', $item->user_id)); ?>"
																   class="text-decoration-none">
																	<div class="d-lg-flex d-block align-items-center ">
																		<div class="mr-3"><img
																				src="<?php echo e(optional($item->user)->profilePicture()??asset('assets/upload/boy.png')); ?>"
																				alt="user"
																				class="rounded-circle" width="35"
																				data-toggle="tooltip" title=""
																				data-original-title="<?php echo e(optional($item->user)->name?? __('N/A')); ?>">
																		</div>
																		<div
																			class="d-inline-flex d-lg-block align-items-center">
																			<p class="text-dark mb-0 font-16 font-weight-medium"><?php echo e(Str::limit(optional($item->user)->name?? __('N/A'),20)); ?></p>
																			<span
																				class="text-muted font-14 ml-1"><?php echo e('@'.optional($item->user)->username?? __('N/A')); ?></span>
																		</div>
																	</div>
																</a>
															</td>
															<td data-label="Product">
																<a href="<?php echo e(route('admin.product.view',$item->id)); ?>"
																   class="text-decoration-none">
																	<div class="d-lg-flex d-block align-items-center ">
																		<div class="mr-3"><img
																				src="<?php echo e(getFile(config('location.product.path').$item->thumbnail)); ?>"
																				alt="user" class="rounded-circle"
																				width="40" data-toggle="tooltip"
																				title=""
																				data-original-title="<?php echo e($item->name); ?>">
																		</div>
																		<div
																			class="d-inline-flex d-lg-block align-items-center">
																			<p class="text-dark mb-0 font-16 font-weight-medium">
																				<?php echo e($item->name); ?></p>
																			<span
																				class="text-muted font-14 ml-1"><?php echo e($item->sku); ?></span>
																		</div>
																	</div>
																</a>
															</td>
															<td data-label="<?php echo app('translator')->get('Category'); ?>"><?php echo e(optional($item->category)->name); ?></td>
															<td data-label="<?php echo app('translator')->get('Currency'); ?>"><?php echo e(optional($item->user->storeCurrency)->name); ?></td>
															<td data-label="<?php echo app('translator')->get('Price'); ?>"><?php echo e(optional($item->user->storeCurrency)->symbol); ?><?php echo e($item->price); ?></td>
															<td data-label="<?php echo app('translator')->get('Status'); ?>">
																<?php if($item->status == 1): ?>
																	<span
																		class="badge badge-info"><?php echo app('translator')->get('Active'); ?></span>
																<?php else: ?>
																	<span
																		class="badge badge-warning"><?php echo app('translator')->get('Inactive'); ?></span>
																<?php endif; ?>
															</td>
															<td data-label="<?php echo app('translator')->get('Action'); ?>">
																<a href="<?php echo e(route('admin.product.view',$item->id)); ?>"
																   class="btn btn-outline-primary btn-sm mr-2"
																   title="<?php echo app('translator')->get('view'); ?>"><i
																		class="fas fa-eye"></i></a>
															</td>
														</tr>
													<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
													</tbody>
												</table>
											</div>
											<div class="card-footer">
												<?php echo e($products->links()); ?>

											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
	</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/admin/store/product/productList.blade.php ENDPATH**/ ?>