<?php $__env->startSection('page_title',__('Insert Redeem Code')); ?>

<?php $__env->startSection('content'); ?>
<div class="main-content">
	<section class="section">
		<div class="section-header">
			<h1><?php echo app('translator')->get('Insert Redeem Code'); ?></h1>
			<div class="section-header-breadcrumb">
				<div class="breadcrumb-item active">
					<a href="<?php echo e(route('user.dashboard')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
				</div>
				<div class="breadcrumb-item"><?php echo app('translator')->get('Insert Redeem Code'); ?></div>
			</div>
		</div>

		<div class="row mb-3">
			<div class="container-fluid" id="container-wrapper">
				<div class="row justify-content-md-center">
					<div class="col-md-12">
						<div class="card mb-4 card-primary shadow">
							<div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
								<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Insert Redeem Code'); ?></h6>
							</div>
							<div class="card-body">
								<form action="<?php echo e(route('redeem.insert')); ?>" method="post">
									<?php echo csrf_field(); ?>
									<div class="row">
										<div class="col-md-12">
											<div class="form-group">
												<label for="utr"><?php echo app('translator')->get('Redeem Code'); ?></label>
												<input type="text" id="redeemCode" value="<?php echo e(old('redeemCode')); ?>"
													   name="redeemCode" placeholder="<?php echo app('translator')->get('xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx'); ?>"
													   class="form-control <?php $__errorArgs = ['redeemCode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
													   autocomplete="off">
												<div class="invalid-feedback">
													<?php $__errorArgs = ['redeemCode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo app('translator')->get($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
												</div>
												<div class="valid-feedback"></div>
											</div>
										</div>
									</div>
									<button type="submit" id="submit" class="btn btn-primary btn-sm btn-block" disabled><?php echo app('translator')->get('Submit redeem code'); ?></button>
								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

	</section>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        'use strict';
        $(document).ready(function () {
            let redeemCodeField = $('#redeemCode');
            let redeemCodeStatus = false;

            function clearMessage(fieldId) {
                $(fieldId).removeClass('is-valid');
                $(fieldId).removeClass('is-invalid');
                $(fieldId).closest('div').find(".invalid-feedback").html('');
                $(fieldId).closest('div').find(".is-valid").html('');
            }

            $(document).on('input', "#redeemCode", function (e) {
                let redeemCode = redeemCodeField.val();

                if (redeemCode.length === 36) {
                    clearMessage(redeemCodeField);
                    $(redeemCodeField).addClass('is-valid');
                    $(redeemCodeField).closest('div').find(".valid-feedback").html('okay');
                    redeemCodeStatus = true;
                    submitButton();
                } else {
                    redeemCodeStatus = false;
                    submitButton();
                    clearMessage(redeemCodeStatus);
                    $(redeemCodeField).addClass('is-invalid');
                    $(redeemCodeField).closest('div').find(".invalid-feedback").html('invalid redeem code length');
                }
            });

            function submitButton() {
                if (redeemCodeStatus) {
                    $("#submit").removeAttr("disabled");
                } else {
                    $("#submit").attr("disabled", true);
                }
            }
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/user/redeem/insert.blade.php ENDPATH**/ ?>