<?php $__env->startSection('page_title', __('KYC List')); ?>

<?php $__env->startSection('content'); ?>
	<div class="main-content">
		<section class="section">
			<div class="section-header">
				<h1><?php echo app('translator')->get('KYC List'); ?></h1>
				<div class="section-header-breadcrumb">
					<div class="breadcrumb-item active">
						<a href="<?php echo e(route('admin.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
					</div>
					<div class="breadcrumb-item"><?php echo app('translator')->get('KYC List'); ?></div>
				</div>
			</div>

			<div class="row mb-3">
				<div class="container-fluid" id="container-wrapper">
					<div class="row">
						<div class="col-lg-12">
							<div class="card mb-4 card-primary shadow-sm">
								<div
									class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
									<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('Search'); ?></h6>
								</div>
								<div class="card-body">
									<form action="<?php echo e(route('kyc.list')); ?>" method="get">
										<?php echo $__env->make('admin.kyc.searchForm', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
									</form>
								</div>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-lg-12">
							<div class="card mb-4 card-primary shadow">
								<div
									class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
									<h6 class="m-0 font-weight-bold text-primary"><?php echo app('translator')->get('KYC List'); ?></h6>
								</div>
								<div class="card-body">
									<div class="table-responsive">
										<table
											class="table table-striped table-hover align-items-center table-borderless">
											<thead class="thead-light">
											<tr>
												<th><?php echo app('translator')->get('SL'); ?></th>
												<th><?php echo app('translator')->get('User'); ?></th>
												<th><?php echo app('translator')->get('Status'); ?></th>
												<th><?php echo app('translator')->get('Submitted At'); ?></th>
												<th><?php echo app('translator')->get('Action'); ?></th>
											</tr>
											</thead>
											<tbody>
											<?php $__empty_1 = true; $__currentLoopData = $kycLists; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
												<tr>
													<td data-label="<?php echo app('translator')->get('SL'); ?>">
														<?php echo e(loopIndex($kycLists) + $key); ?>

													</td>
													<td data-label="<?php echo app('translator')->get('User'); ?>">
														<a href="<?php echo e(route('user.edit', $value->user_id)); ?>"
														   class="text-decoration-none">
															<div class="d-lg-flex d-block align-items-center ">
																<div class="mr-3"><img
																		src="<?php echo e(optional($value->user)->profilePicture()??asset('assets/upload/boy.png')); ?>"
																		alt="user"
																		class="rounded-circle" width="35"
																		data-toggle="tooltip" title=""
																		data-original-title="<?php echo e(optional($value->user)->name); ?>">
																</div>
																<div
																	class="d-inline-flex d-lg-block align-items-center">
																	<p class="text-dark mb-0 font-16 font-weight-medium"><?php echo e(Str::limit(optional($value->user)->name?? __('N/A'),20)); ?></p>
																	<span
																		class="text-muted font-14 ml-1"><?php echo e('@'.optional($value->user)->username); ?></span>
																</div>
															</div>
														</a>
													</td>
													<td data-label="<?php echo app('translator')->get('Status'); ?>">
														<?php if($value->status == '1'): ?>
															<span class="badge badge-success"><?php echo app('translator')->get('Approved'); ?></span>
														<?php elseif($value->status == '0'): ?>
															<span class="badge badge-warning"><?php echo app('translator')->get('Pending'); ?></span>
														<?php elseif($value->status == '2'): ?>
															<span class="badge badge-danger"><?php echo app('translator')->get('Rejected'); ?></span>
														<?php endif; ?>
													</td>
													<td data-label="<?php echo app('translator')->get('Submitted At'); ?>"><?php echo e(dateTime($value->created_at,'d/m/Y H:i')); ?></td>
													<td data-label="<?php echo app('translator')->get('Action'); ?>">
														<a href="<?php echo e(route('kyc.view',$value->id)); ?>"
														   class="btn btn-outline-primary btn-sm"><?php echo app('translator')->get('View'); ?></a>
													</td>
												</tr>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
												<tr>
													<th colspan="100%" class="text-center"><?php echo app('translator')->get('No data found'); ?></th>
												</tr>
											<?php endif; ?>
											</tbody>
										</table>
									</div>
									<div class="card-footer">
										<?php echo e($kycLists->links()); ?>

									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

		</section>
	</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('extra_scripts'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\Paysecure-wallet\project\resources\views/admin/kyc/index.blade.php ENDPATH**/ ?>